<?php
/**
 * @package Services_PayPal
 */

/**
 * Make sure our parent class is defined.
 */
require_once 'Services/PayPal/Type/XSDSimpleType.php';

/**
 * BasicAmountType
 * 
 * On requests, you must set the currencyID attribute to one of the three-character
 * currency codes for any of the supported PayPal currencies.
 *
 * @package Services_PayPal
 */
class BasicAmountType extends XSDSimpleType
{
    function BasicAmountType()
    {
        parent::XSDSimpleType();
        $this->_namespace = 'urn:ebay:apis:CoreComponentTypes';
        $this->_attributes = array_merge($this->_attributes,
            array (
              'currencyID' => 
              array (
                'name' => 'currencyID',
                'type' => 'ebl:CurrencyCodeType',
                'use' => 'required',
              ),
            ));
    }

}
