<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: api_create.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/API.php';
require_once 'Services/PayPal/Profile/Handler.php';
require_once 'lib/api_form_validators.inc.php';
require_once 'lib/functions.inc.php';

session_start();

$dummy= @new APIProfile();
$environments = $dummy->getValidEnvironments();

$was_submitted = false;

if(isset($_POST['submitted']))
{
    unset($_POST['submitted']);
    unset($_POST['action']);

    $was_submitted = true;

    $errors = validate_form_input($_POST);

    if(!isset($_FILES['certificate_file']))
    {
        $errors['certificate_file'] = "You must provide a Certificate for the profile";
    }
    else
    {
        if(!file_exists($_FILES['certificate_file']['tmp_name']))
        {
            $errors['certificate_file'] = "You must provide a Certificate for the profile";
        }
        else
        {
            if(!is_uploaded_file($_FILES['certificate_file']['tmp_name']))
            {
                $errors['certificate_file'] = "Invalid file upload, cannot save profile";
            }
        }
    }

    $cert_save_path = _getProfileCertSavePath();

    if(Services_PayPal::isError($cert_save_path))
    {
        $errors['unknown'][] = $cert_save_path->getMessage();
    }

    if(empty($errors))
    {
        $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

        if(!Services_PayPal::isError($handlerinst))
        {
            $pid = ProfileHandler::generateID();

            $profile = new APIProfile($pid, $handlerinst);

            $save_file = "$cert_save_path/$pid.cert";

            if(!move_uploaded_file($_FILES['certificate_file']['tmp_name'],
                                   $save_file))
            {
                $errors['unknown'][] = "Could not store uploaded certificate '{$_FILES['certificate_file']['tmp_name']}'";
            }

            $profile->setAPIUsername($_POST['api_username']);
            $profile->setSubject($_POST['api_subject']);
            $profile->setEnvironment($_POST['environment']);
            $profile->setCertificateFile($save_file);

            $result = $profile->save();

            if(Services_PayPal::isError($result))
            {
                $errors['unknown'][] = "Could not create new profile: ".$result->getMessage();
            }
        }
        else
        {
            $errors['unknown'][] = "Could not create a new Profile Handler: ". $handlerinst->getMessage();
        }

    }

}

require_once "pages/api_create.html.php";
