<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: index.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'lib/functions.inc.php';

session_start();

$handler_paths = _getHandlerPaths();
$handlers = _loadProfileHandlerClasses($handler_paths);

if (!empty($_SESSION['pphandler']) && key_exists($_SESSION['pphandler'], $handlers)) {
    header('Location: main.php');
    exit;
}
elseif(isset($_GET['submitted']))
{
    if(!isset($_GET['pphandler']))
    {
        trigger_error("Invalid submission, no handler specified", E_USER_ERROR);
        exit;
    }

    if(key_exists($_GET['pphandler'], $handlers))
    {
        $_SESSION['charset'] = $_GET['charset'];
        $_SESSION['pphandler'] = $_GET['pphandler'];
        $params = $_GET;
        unset($params['submitted']);
        unset($params['pphandler']);
        $_SESSION['pphandler_params'] = $params;

        header("Location:  main.php");
        exit;
    }
    else
    {
        trigger_error("Invalid handler '{$_GET['pphandler']}' submitted, possible attack.", E_USER_ERROR);
        exit;
    }
}

require_once 'pages/index.html.php';
