<?php

/*
 * This is wlogin, a php front end to chillispot.
 *
 * 	last change 2005-11-18
 *
 *		This is a slightly modified version of wlogin-1.20 by "drewb" (http://drewb.com).
 *		The only changes include slight logical additions and increased compatibility for
 *		for PHP installs that do not/cannot set the "register_globals on" in PHP.INI -
 *		If you have any questions or trouble with these scripts, DO NOT contact the original
 *		author - visit http://brentscheffler.com/blog
 *
 *
 * Re-implementation of hotspotlogin03.php by Cedric which was forked
 * from original chillispot.org's hotspotlogin.cgi by Kanne
 *
 *
 */

define("INC_DIR", "../site-lib/");

require_once(INC_DIR . "config.inc");

/*
 * possible Cases:
 *
 *  attempt to login                          login=Login
 *  1: Login successful                       res=success
 *  2: Login failed                           res=failed
 *  3: Logged out                             res=logoff
 *  4: Tried to login while already logged in res=already
 *  5: Not logged in yet                      res=notyet
 * 11: Popup                                  res=popup1
 * 12: Popup                                  res=popup2
 * 13: Popup                                  res=popup3
 *  0: It was not a form request              res=""
 *
 * Read query parameters which we care about
 *
 * $_GET['res'];
 * $_GET['challenge'];
 * $_GET['uamip'];
 * $_GET['uamport'];
 * $_GET['reply'];
 * $_GET['userurl'];
 * $_GET['timeleft'];
 * $_GET['redirurl'];
 *
 * Read form parameters which we care about
 *
 * $_GET['username'];
 * $_GET['password'];
 * $_GET['chal'];
 * $_GET['login'];
 * $_GET['logout'];
 * $_GET['prelogin'];
 * $_GET['res'];
 * $_GET['uamip'];
 * $_GET['uamport'];
 * $_GET['userurl'];
 * $_GET['timeleft'];
 * $_GET['redirurl'];
 * $_GET['store_cookie'];
 */

if (isset($_GET["login"]) && $_GET["login"] == "Login" ) {
  $context = "login";
}
elseif (isset($_GET['res'])) {
  $context = $_GET["res"];
}
else $context = 'error';



/*
 * We need to put some standard arguments in a string for the onLoad
 * javascript function that we run on every page load.  These are:
 * context, timeleft, and next_url.
 *
 * Other arguments may be appended to these in the context specific
 * include file before the top.inc header is spit out.  In that case,
 * we'll need to remember to attach a comma before the extra args.
 */
$js_args = "'" . $context . "',";

if(isset($_GET['timeleft'])) $js_args  =  " '" . $_GET["timeleft"] . "',";
$js_args .= "'" . LOGINPATH . "?res=popup3";
if(isset($_GET["uamip"])) $js_args .= "&uamip=" . $_GET["uamip"];
if(isset($_GET['uamport'])) $js_args .= "&uamport=" . $_GET["uamport"] . "'";

/*
 * If we want to store the cookie, compose and set it...
 */
if (isset($_GET["save_login"]) && $_GET['save_login'] == "on" ) {
  $str = $_GET["uid"] . "|" . $_GET["pwd"];

  // expires in 10 years...
  $expire = time() + 315360000;

  setcookie("login", $str, $expire, "/", $_SERVER["HTTP_HOST"], true);
}

if ( isset($_COOKIE["login"]) ) {
  $arr = explode("|", $_COOKIE["login"]);

  $username = $arr[0];
  $password = $arr[1];
}
else {
  $username = "";
  $password = "";
}

if ( is_file(INC_DIR . $context . ".inc") ) {
  include(INC_DIR . $context . ".inc");
}
else
{
	include(INC_DIR . 'error.inc');
}

?>
