<?php 
/** 
* Creates a table from an array using the PEAR table class. 
* 
* Usage: 
* $data is just a normal array: 
* $data = array("Cell 1", "Cell 2", "Cell 3", "Cell 4", "Cell 5", "Cell 6"); 
* $smarty->assign("data", $data); 
* and your table is created :-) 
* 
* syntax: {table loop=$varname 
*                cols=int 
*                caption=string 
*                caption_attr=string 
*                header=string 
*                header_attr=string 
*                table_attr=string 
*                td_attr=string 
*                td_width=width_col1|width_col2|... max up to 'cols'
*                altrows=string 
*                arrange=horizontal|vertical 
*         } 
* 
* All attributes except 'loop' are optional. 
* Please note that the syntax of the altrows tag is as follows: 
*      altrows='row1attr|row2attr' 
* 
* Please note that the syntax of the td_attr has one optional argument:
*      td_attr='width1|width2|width3|....' number of width value
			must be equal to the cols tag
*
* A tutorial and full documentation can be found at: 
* http://www.mapledesign.co.uk/coding/ 
* 
* To improve: 
* - The way the default attributes are set.  I need some ideas :-) 
*   the current way means that if you change the default values then you have 
*   to do so every time you upgrade this function.  A way round this would be 
*   to define the values, so you can set them in your application if you want. 
*   At the top of this file I'd have: 
*         if (!defined(SMARTY_TABLE_COLS)) { 
*              define('SMARTY_TABLE_COLS', '2'); 
*         } 
*   and then below it: 
*         $cols = (isset($cols)) 
*                  ? $cols 
*                  : SMARTY_TABLE_COLS; 
* 
*   This would allow you to easily set the defaults on an application level 
*   making upgrading easier. 
* - Variable naming within the function, as I don't think I'm using $_ in 
*   varnames correctly.  CAN SOMEONE PLEASE ADVISE as I haven't a clue! 
* - Clean up the {table} tag's attributes, as it's rather messy and long at 
*   the moment.  Some of the names are not obvious.  If you have improvements 
*   to suggest then please email me. 
* 
***************************************************************************** 
* This code has been released as tipware - if you use it then please make a 
* donation or buy me something from my Amazon wishlist.  Full details can be 
* found @ http://sendcard.resource-locator.com/moral.php 
***************************************************************************** 
* 
* @author Peter Bowyer <peter@mapledesign.co.uk> 
* @version 1.0 
* @access public 
* @param array $_args attributes passed from the smarty tag. 
* @return true 
*
* 2002-10-05 td_width attribute added Gunther Richter
*/  
function smarty_function_table($_args) 
{ 
    // Get the $_args array into 'normal' variables. 
    extract($_args); 
     
    // Check if the loop is set 
    // IS THIS NECESSARY?  SLOWS DOWN THE CODE FOR A VERY BASIC ERROR WHICH 
    // SHOULD NEVER OCCUR! 
    if (!isset($loop) || !is_array($loop) || empty($loop)) { 
        return trigger_error('Parameter "loop" of {table} is not an array'); 
    } 
     
    // Fill the variables if not set. 
    $cols = (isset($cols)) 
            ? $cols  
            : 2 ; 
    $caption = (isset($caption)) 
            ? $caption  
            : "" ; 
    $caption_attr = ( isset($caption_attr) ) 
            ? $caption_attr 
            : 'align="top"' ; 
    $header = ( isset($header) ) 
            ? array($header)  
            : '' ; 
    $header_attr = ( isset($header_attr) ) 
            ? $header_attr 
            : '' ; 
    $table_attr = ( isset($table_attr) ) 
            ? $table_attr 
            : 'align="center" border="0"' ; 
    $td_attr = ( isset($td_attr) ) 
            ? $td_attr 
            : 'align="center"' ; 
    $td_width = ( isset($td_width) ) 
            ? $td_width	// format: width="25%|24%|..."
            : '' ; 
    $pad_val = ( isset($pad_val) ) 
            ? $pad_val 
            : '&nbsp;' ; 
             
    $arrange = ( isset($arrange) ) 
            ? $arrange 
            : 'horizontal' ; 
             
     
    /************************************************************************** 
     Nothing below this line should need changing 
    **************************************************************************/  
    // Require the table class 
    // IMPORTANT!!!!!  SHOULD THIS GO OUTSIDE THE FUNCTION TO WORK PROPERLY? 
    require_once 'HTML/Table.php'; 
    $table = new HTML_Table($table_attr); 
     
    // Add a header to the table if desired. 
    if ($header != '') { 
        $table->addRow($header, "colspan=\"$cols\" " . $header_attr, "TH"); 
    } 
    if ($caption) { 
        $table->setCaption($caption, $caption_attr); 
    } 
    // Calculate the number of rows needed to hold all the data. 
    $_rows = ceil(count($loop) / $cols); 
     
     
    // Pad array if not the right length - prevents any collapsing table cells 
    //$loop = array_pad($loop, $_rows * $cols, $pad_val); 
    // Above line shouldn't be needed with the following 
    $table->setAutoFill($pad_val); 
     
    switch(strtolower($arrange)){ 
        case 'vertical': 
            /* 
             * Orders the items in the array like 
             * cell 1  cell 4 cell 7 
             * cell 2  cell 5 cell 8 
             * cell 3  cell 6 cell 9 
             */ 
            foreach ($loop as $key => $value) { 
                $_data[] = $value; 
                if (0 == count($_data) % $_rows) { 
                           $table->addCol($_data); 
                           $_data = null; 
                       } 
            } 
            // If there's any data left, assign it to a column 
            if (isset($_data)) { 
                $table->addCol($_data); 
            } 
            break; 
        case 'horizontal': 
        default: 
            /* 
             * Orders the items in the array like 
             * cell 1  cell 2 cell 3 
             * cell 4  cell 5 cell 6 
             * cell 7  cell 8 cell 9 
             */ 
            foreach ($loop as $key => $value) { 
                $_data[] = $value; 
                if (0 == count($_data) % $cols) { 
                           $table->addRow($_data); 
                           $_data = null; 
                       } 
            } 
            // If there's any data left, assign it to a row 
            if (isset($_data)) { 
                $table->addRow($_data); 
            } 
            break; 
    } 

/*     
    //THE ORIGINAL FUNCTION USED - KEPT IN CASE OF PROBLEMS WITH THE ABOVE 
    $_i = 0; 
    // Loop through the rows. 
    for($i = 0; $i < $_rows; $i++){ 
        // Assign the column values for each row. 
        for($j = 0; $j < $cols; $j++){ 
            $data[$i][] = $loop[($_i + $j)]; 
        } 
    // Keep track of the number of cells filled, so you don't repeat any values. 
    $_i = $_i + $j; 
    } 

    // Now add the rows to the table. 
    for($i = 0; $i < $_rows; $i++){ 
        $table->addRow($data[$i]); 
    } 
*/     

    // Check to see if alternate rows are set 
    if (isset($altrows)){ 
        $_attr = explode("|", $altrows); 
        $table->altRowAttributes(($header ? 1 : 0), $_attr[0], $_attr[1]); 
    } 
     
    // Check to see if cell attributes are set 
    if (isset($td_attr)){ 
        for($i = ($header ? 1 : 0) ; $i < ($_rows + ($header ? 1 : 0)); $i++){  
            $table->updateRowAttributes($i,$td_attr);  
		}
	} 

    // set cell width for each cell - GR 2002
	if (isset($td_width)){ 
        for($i = ($header ? 1 : 0) ; $i < ($_rows + ($header ? 1 : 0)); $i++){  
			foreach (explode("|", $td_width) as $key => $value) {
				$table->updateCellAttributes($i,$key,"width=".$value);  
			}
        }
    }
 	 
    // Finally, display the table. 
    $table->display(); 
    return; 
} // End Function smarty_function_table 
?> 
