<?php
/***************************************************************
*
*	Profile page
*	
*	2006-01-08 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN+PHS_PERM_PUSER+PHS_PERM_USER);

/*
Array
(
    [firstname] => Christopher
    [lastname] => Chin Lee
    [phone] => (868) 624-1181
    [fax] => (868)624-0108
    [cell] => (868)680-6495
    [email] => cchinlee@normandiett.com
    [password1] => 123456
    [password2] => 123456
    [submit2] => submit
)
*/
$_password = '';
$_pwchange = False;
$_timeFormat = (PHS_TIME24 ? '24' : '12');
$_myLanguage = $phs_client_info['client_contact_lang'];
$a->setAuthData('Phs_NextPage', PHS_FILE_PROFILE);

  // set row for display
$rowin = array(
       'client_contact_id'          => $phs_client_info['client_contact_id'],
       'client_contact_lastname'    => $phs_client_info['client_contact_lastname'],
       'client_contact_firstname'   => $phs_client_info['client_contact_firstname'],
       'client_contact_phone'       => $phs_client_info['client_contact_phone'],
       'client_contact_fax'         => $phs_client_info['client_contact_fax'],
       'client_contact_mobile'      => $phs_client_info['client_contact_mobile'],
       'client_contact_email'       => $phs_client_info['client_contact_email']
       //'client_contact_lang'        => $phs_client_info['client_contact_lang']
);

if (isset($Phs_POST['submit2'])) {
  //print_r($Phs_POST);

  $_firstname = trim($Phs_POST['firstname']);
  $_lastname  = trim($Phs_POST['lastname']);
  $_phone     = trim($Phs_POST['phone']);
  $_fax       = trim($Phs_POST['fax']);
  $_mobile    = trim($Phs_POST['cell']);
  $_email     = trim($Phs_POST['email']);
  $_password1 = trim($Phs_POST['password1']);
  $_password2 = trim($Phs_POST['password2']);
  $_timeFormat = trim($Phs_POST['timeFormat']);
  $_myLanguage = trim($Phs_POST['lang_id']);

  if (empty($_firstname)) {
    $Phs_ErrMsg = 'First Name missing';
    $process_error = True;
  } elseif (empty($_lastname)) {
    $Phs_ErrMsg = 'Last Name missing';
    $process_error = True;
    // password changed?
  } elseif ($_password1 <> PHS_PW_DUMMY) {
      // both passwords same
    if ($_password1 <> $_password2) {
      $Phs_ErrMsg = 'Password mismatch';
      $process_error = True;
      // all is fine, save it now
    } elseif (strlen($_password1) < PHS_LEN_PW) {
      $Phs_ErrMsg = 'Password too short! Password must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (strlen($_password1) > PHS_LEN_PW_MAX) {
      $Phs_ErrMsg = 'Password too long! Id must be between ' . PHS_LEN_PW . ' - ' . PHS_LEN_PW_MAX . ' characters';
      $process_error = True;
    } elseif (ereg('[^a-zA-Z0-9_.-]{1,}', $_password1)) {
      $Phs_ErrMsg = 'Only use a-z, 0-9, _.- and no spaces for the password';
      $process_error = True;
    } else {
      $Phs_InfoMsg = 'Password changed';
      $_pwchange = True;
      //print(' OKOKOK ');
    }
  } 
  
  if (!$process_error) { 
    // all is fine, update record
    //print(' UPDATE DATA ');

    $rowin = array(
       'client_contact_id'          => $phs_client_info['client_contact_id'],
       'client_contact_lastname'    => $_lastname,
       'client_contact_firstname'   => $_firstname,
       'client_contact_phone'       => $_phone,
       'client_contact_fax'         => $_fax,
       'client_contact_mobile'      => $_mobile,
       'client_contact_email'       => $_email,
       'client_contact_timeFormat'  => $_timeFormat,
       'client_contact_lang'        => $_myLanguage
    );

    if ($_pwchange) {
      $rowin['client_contact_password'] = $_password1;
    }

    if (($Phs_ErrMsg = $dbc->updateClientContact($rowin)) <> Null) {
        // OK, we got an error
      $process_error = True;
    } else {
      $Phs_InfoMsg .= ($_pwchange ? ' and ' : '') . 'Profile updated';
    }
  }
} 
if ($_timeFormat  == '24') {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; G:i"); 
  $smarty->assign('24hour', ' selected ');
} else {
  $showdate   = date("D, j M Y \&\\n\b\s\p\; g:i a"); 
  $smarty->assign('12hour', ' selected ');
}
  // to display immediate change
$smarty->assign('PhsDateTime', $showdate);

//$smarty->assign('lang_idx', array('de','en'));
  // first language support code (hard coded)
$smarty->assign('lang_idx', $Phs_languagesIdx);
$smarty->assign('lang_names', $Phs_languages);
$smarty->assign('lang_id', $_myLanguage);

$_password = PHS_PW_DUMMY; // only show dummy password in form

//print_r($phs_client_info);

$smarty->assign('profileForm', True);
$smarty->assign('_password', $_password);
$smarty->assign('clientInfo', $rowin);
$smarty->assign('mainHeadline', 'Profile for: ' . $phs_username);
require_once('includes/trailer-inc.php');
$smarty->display('profile.tpl');
?>
