<?php
/***************************************************************
*
*	pointHotspot Payment confirmed page (called by PayPal)
*	
*	2006-04-18 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize
include_once("includes/class.paypalPDTBase.php") ;

class doPaypalPDT extends paypalPDTBase
{
    function doPaypalPDT($theReceiverEmail, 
                              $thePDTIdentityToken,
                              $thePaypalURL = NULL, 
                              $theSandboxURL = NULL)
    {
        $this->paypalPDTBase($theReceiverEmail, $thePDTIdentityToken, $thePaypalURL, $theSandboxURL) ;
    }
    
    function preprocess(&$theSource)
    {
      // assign here if in test mode or not
        //$theSource = array_merge(array('test_pdt' => '1'), $theSource) ;
        //print("\npreProcess");
        //print_r($theSource);
        return true ;
    }
    
    function preprocessPDT(&$thePDT)
    {
       // echo 'preprocessPDT:thePDT = ',SDD::dump($thePDT),SDD::newline() ;
        //print("\npreProcessPDT");
    }
    
    // IPN specific?
    function checkTransactionId($theTransactionId)
    {
        //echo 'checkTransactionId = ',SDD::dump($theTransactionId),SDD::newline(2) ;
        //print("\ncheckTransactionId");
        return TRUE ;
    }

    // IPN specific?
    function validateItem(&$thePDT)
    {
        //echo 'validateItem:thePDT = ',SDD::dump($thePDT),SDD::newline(2) ;
        //print("\nvalidateItem");
        return TRUE ;
    }

    // IPN specific?
    function alternatePaymentStatus(&$thePDT)
    {
        //echo 'alternatePaymentStatus:thePDT = ',SDD::dump($thePDT),SDD::newline(2) ;
        //print("\nalternatePaymentStatus");
        return TRUE ;
    }

    function processPayment(&$thePDT)
    {
        //echo 'processPayment:thePDT = ',SDD::dump($thePDT),SDD::newline(2) ;
        //print("\nprocessPayment");
        return TRUE ;
    }

    function postprocess(&$thePDT, $theStatus)
    {
        //global $_pdtArray;
        //echo 'postprocess:thePDT = ',SDD::dump($thePDT),SDD::newline(2) ;
        //echo 'postprocess:theStatus = '.SDD::dump($theStatus),SDD::newline(2) ;
        //print("\npostprocess\n");
        //$_pdtArray = $thePDT; // return PDT to main
        //print_r($thePDT);
        //print_r($theStatus);
    }    
} ;



$ppResultHeader = '';
//$_ppTestMode = ''; // No PayPal test mode
//$_ppTestMode = 'sandbox.'; // PayPal test mode

// get returning PayPal PDT parameters

// read the post from PayPal system and add 'cmd'
//$req = 'cmd=_notify-synch';
$_processError = False;
$Phs_ErrMsg = '';
$Phs_InfoMsg = '';
//$_pdtArray = array(); // reserved fro post PDT from PayPal

if (count($_GET) > 0) {

/* 
  Identify PayPal request and get client entry for the site
  To identify a client, the PayPal GET string contains one hint: cm=
  - client ID as stored in the 'custom' string: 2&64 = cid=2, usid=64
  TABLE A.11 PDT-Specific Variables
  Variable Description
  - tx Transaction ID/PDT token
  - st Transaction status
  - amt Amount of the transaction
  - cc Currency code
  - cm Custom message

  Additional test:
  1. Is request coming from paypal?
*/


  if (!isset($_GET['cm'])) {
    $_processError = True;
    $Phs_ErrMsg = 'Custom Info not found - Please contact provider!';
  } else {
//    print('cm='.$_GET['cm']);
    $_customArray = explode('&', $_GET['cm']);
    $_clientSiteId = $_customArray[0]; // 0 index is clientSiteID
    $_userId = $_customArray[1]; // 0 index is user_id
    $_orderNum = $_customArray[2]; // 0 index is order_invoice_no
    $_txnId = $_GET['tx']; // PayPal transaction ID
    //print_r($_customArray);

    //print('cls='.$_clientSite);
    if (!($clientInfo = $dbc->getClientInfo($_clientSiteId)) <> Null) {
      $_processError = True;
      $Phs_ErrMsg = 'Provider information could not be found - Please contact provider!';
    } else {

      //print_r($clientInfo);

      // set to client time zone
      define('PHS_TZONE', $clientInfo['client_address_tzone']);
      putenv('TZ=' . PHS_TZONE);

      //print(' tZone:'.PHS_TZONE);

// check if there is a order with status pending for this userid


      

/*
[pp_client_id] => 1
[pp_client_client_site_id] => 2
[pp_client_status] => 0
[pp_client_receiver_email] => richter@pointhotspot.com
[pp_client_identity_token] => aRy-w8U-x0kojV1234567890123456w0bF4IotGR-62THnKeXbM2c-_m11q
[pp_client_ndate] => 2006-04-26 18:17:46
[pp_client_mdate] => 2006-04-26 18:18:27

order status bit flags:
- nothing
- pending (forwarded to payment processor)
- confirmed (return from payment proc)
- paid
- declined
- pp_pending - pending at payment processor

Order Status states:
define ('PHS_ORDER_STATUS_DEFAULT', 0); // no particular state
define ('PHS_ORDER_STATUS_PENDING', 0x1); // pending after order inserted and off to pp
define ('PHS_ORDER_STATUS_CONFIRMED', 0x2); // confirmed, not yet paid
define ('PHS_ORDER_STATUS_PAID', 0x4); // confirmed, and paid
define ('PHS_ORDER_STATUS_PP_PENDING', 0x8); // confirmed, but payment pending (eCheck)
define ('PHS_ORDER_STATUS_DECLINED', 0x16); // declined
define ('PHS_ORDER_STATUS_FAILED', 0x32); // failed

*/

    //print_r($clientInfo);

      if (!isset($clientInfo['pp_client_receiver_email'])) {
        $_processError = True;
        $Phs_ErrMsg = 'Provider Email Address missing - Please contact provider!';
      } else {

        $_clientEmail = $clientInfo['pp_client_receiver_email'];
        $_clientPDTIdentityToken = $clientInfo['pp_client_identity_token'];

          // set order status to confirmed
        if (($_retmsg = $dbc->setOrderStatus($clientInfo['pp_client_client_site_id'], $_orderNum, PHS_ORDER_STATUS_CONFIRMED)) <> Null) {
          $_processError = True;
          $Phs_ErrMsg = $_retmsg;
        }
    //print('email:'.$_clientEmail.' tk:'.$_clientPDTIdentityToken);
        $thePDT = new doPaypalPDT($_clientEmail, 
                                       $_clientPDTIdentityToken,
					'http://ultragate.com/sec/on2/testpdt.php',
					'http://ultragate.com/sec/on2/testpdt.php?sandbox');
/*
                                       'http://www.paypal.com/cgi-bin/webscr',
                                       'http://www.sandbox.paypal.com/cgi-bin/webscr') ;
*/

        $thePDTData = array() ;
        
        //$theReturnStatus = $thePDT->processNotification($_GET, $thePDTData) ;
        $theReturnStatus = $thePDT->processNotification($_GET) ;

       // print('thePDT -> ');
        //print_r($thePDT->m_data->m_IPNData);
       // print(' <- thePDT ');
       // print(' theReturnStatus-> ');
       // print($theReturnStatus);
       // print(' <- $theReturnStatus');
        if ($theReturnStatus == False) {
          $_processError = True;
          $Phs_ErrMsg = 'Payment transaction failed - Please contact provider!';
          if (($_retmsg = $dbc->setOrderStatus($clientInfo['pp_client_client_site_id'], $_orderNum, PHS_ORDER_STATUS_FAILED)) <> Null) {
            $_processError = True;
            $Phs_ErrMsg = $_retmsg;
          }
        } else {
          if (!is_null($_retmsg = $dbc->insertPPTransaction($_clientSiteId, $thePDT->m_data->m_IPNData))) {
            $_processError = True;
            $Phs_ErrMsg = $_retmsg;
          } else {

/*
payment_status:
    Accepted:
      Completed
      Pending - accepted if echeck
      In-Progress
      Processed

    Not accepted:
      Canceled_Reversal
      Denied
      Expired
      Failed
      Partially-Refunded
      Refunded
      Reversed
      Voided
*/
            $_paymentAccepted = False;
            switch ($thePDT->m_data->m_IPNData['payment_status']) {
                // payment success
            case 'Completed':
            case 'Processed':
            case 'In-Progress':
              $_paymentAccepted = True;
              break;
            case 'Pending': // OK if echeck
              if ($thePDT->m_data->m_IPNData['pending_reason'] == 'echeck') {
                $_paymentAccepted = True;
              }
              break;
            default:
                // payment failed
            }

            if ($_paymentAccepted) {
              // set order status

                // get user entry
              if (($userarray = $dbc->getUserEntry($_userId, $_clientSiteId, $_orderNum)) == Null) {
                $Phs_ErrMsg = 'User not found';
                $_processError = True;
              } else {
                //print_r($userarray);
                if ($userarray['order_status'] == PHS_ORDER_STATUS_PAID) {
                  $Phs_ErrMsg = 'Transaction already processed';
                  $_processError = True;
                } else {
                  if (($_retmsg = $dbc->setOrderStatus($clientInfo['pp_client_client_site_id'], $_orderNum, PHS_ORDER_STATUS_PAID)) <> Null) {
                    $_processError = True;
                    $Phs_ErrMsg = $_retmsg;
                  } else {
                      // now set expiry date/time in phs_user table and update group
                    $rowin = array(
                      'user_id'                 => $_userId,
                      'uuname'                  => $userarray['uuname'],
                      'user_payment'            => 'PayPal: ' . $thePDT->m_data->m_IPNData['payment_status'] . ($thePDT->m_data->m_IPNData['payment_status'] == 'Pending' ? ' (' . $thePDT->m_data->m_IPNData['pending_reason'] . ')' : ''),
                      'user_status'             => PHS_ST_INACTIVE,
                      'user_client_id'          => $_clientSiteId,
                      'access_plan_interval'    => $userarray['access_plan_interval'],
                      'package_type_radgroupext' => $userarray['package_type_radgroupext'],
                      'order_amount'      => $thePDT->m_data->m_IPNData['mc_gross'],
                      'order_invoice_no'  => $thePDT->m_data->m_IPNData['invoice']
                    );


                    /*
                      order entry needs to be updated too
                        - order_amount (in case it has changed since insert)
                        - order_expiry_date (mainly for tracking purpose)
                    */

        //            print_r($rowin);
                    if (($Phs_ErrMsg = $dbc->updateUserEntry($rowin)) <> Null) {
                      $_processError = True;
                    } else {
                        //print(' PAYMENT HAS BEEN ACCEPTED ');
                      $Phs_InfoMsg = 'Payment successfully completed!';
                      if (($userarray = $dbc->getUserEntry($_userId, $_clientSiteId, $_orderNum)) == Null) {
                        $Phs_ErrMsg = 'UserId not found';
                        $_processError = True;
                      } else {
        //            print_r($userarray);
                    /*
                        $smarty->assign('name', $userarray['user_firstname'] . ' ' . $userarray['user_lastname']);
                        $smarty->assign('item', $thePDT->m_data->m_IPNData['item_name']);
                        $smarty->assign('expiry', $userarray['user_stoptime']);
                        $smarty->assign('amount', '$ ' . $thePDT->m_data->m_IPNData['mc_gross']) . ' ' . $thePDT->m_data->m_IPNData['mc_currency'];
                        $smarty->assign('invoice', $thePDT->m_data->m_IPNData['invoice']);
                        $smarty->assign('date', date(PHS_ISODATETIME));
                        */
                        $ppResultHeader = '';

                      }
                    }
                  }
                }
              }
            } else {
              $Phs_InfoMsg = 'Payment failed!';
            }
          }


/* 
get information to be displayed

  - Name:
  - Online Time Package:
  - Expiry:
  - Amount:
  - Invoice No: 
*/


        }
      }
    }
  }
  //if ($_processError) print('Process error');
} else {
  //print('get back to signup or renew page');

}
$smarty->assign('name', (isset($thePDT->m_data->m_IPNData['first_name']) ? $thePDT->m_data->m_IPNData['first_name'] . ' ' . $thePDT->m_data->m_IPNData['last_name'] : 'not available'));
$smarty->assign('item', (isset($thePDT->m_data->m_IPNData['item_name']) ? $thePDT->m_data->m_IPNData['item_name'] : 'not available'));
$smarty->assign('expiry', (isset($userarray['user_stoptime']) ? $userarray['user_stoptime']: 'not available'));
$smarty->assign('amount', '$ ' . (isset($thePDT->m_data->m_IPNData['mc_gross']) ? $thePDT->m_data->m_IPNData['mc_gross'] . ' ' . $thePDT->m_data->m_IPNData['mc_currency'] : $_GET['amt'] . ' ' . $_GET['cc']));

$smarty->assign('invoice', $_orderNum);
$smarty->assign('date', date(PHS_ISODATETIME));
$smarty->assign('txnid', $_txnId);
$smarty->assign('supportEmail', (isset($clientInfo['client_address_support_email']) ? '<a href="mailto:' . $clientInfo['client_address_support_email'] . '">contact</a>' : ''));
$smarty->assign('supportUrl', (isset($clientInfo['client_address_support_url']) ? '<a href="' . $clientInfo['client_address_support_url'] . '" target="_blank">Contact us</a><br/>' : ''));
$smarty->assign('ppResultHeader', $ppResultHeader);
$smarty->assign('fileName', 'mainConfirmed.tpl');
$smarty->assign('phs2sp_javaScript', '_dummy.tpl');
$smarty->assign('title', 'OIFNET HOTSPOT Subscription Service');
$smarty->assign('loginURL', 'http://www.google.com');

if (isset($_clientAcctEmail)) {
  session_destroy();
}
require_once('includes/trailer-inc.php');
$smarty->display('confirmed.tpl');

?>
