<?php

//
// Edit History:
//
//  Last $Author: munroe $
//  Last Modified: $Date: 2006/03/13 18:05:15 $
//
//  Dick Munroe (munroe@csworks.com) 28-Feb-2006
//      Initial version created
//

/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ 2006 by Dick Munroe, Cottage Software Works, Inc.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package dm.paypal
 * @example ./example.php
 *
 * This is derived from a paypal IPN class written originally by Herve Foucher
 * <Herve.Foucher@helio.org> and published through phpclasses.org under the GPL.
 * Herve appears to no longer support this package so I'm updating the support
 * to 1.6 and redesigning a bunch of the internal structure to allow a substantially
 * more object oriented approach to the whole problem.
 *
 * This object captures the IPN Advanced and Custom Information as given in table A.3 of the
 * Order Management Integration Guide.
 */

include_once('class.paypalIPNDataBase.php') ;

class paypalIPNSubscriptions extends paypalIPNDataBase
{
    var $subscr_date ;
    var $subscr_effective ;
    var $period1 ;
    var $period2 ;
    var $period3 ;
    var $amount1 ;
    var $amount2 ;
    var $amount3 ;
    var $mc_amount1 ;
    var $mc_amount2 ;
    var $mc_amount3 ;
    var $mc_currency ;
    var $recurring ;
    var $reattempt ;
    var $retry_at ;
    var $recur_times ;
    var $username ;
    var $password ;
    var $subscr_id ;
    
    /**
     * @desc Auctions information constructor
     * @param array $theSource [by reference] post data of the IPN.
     */
    
    function paypalIPNSubscriptions(&$theSource)
    {
	$this->paypalIPNDataBase($theSource) ;
    }
}
?>
