<?php 
    require_once '../lib/functions.inc.php';
    session_start();
    
    if(empty($_SESSION['payerID']))
    {
        do_error("No Payer ID found!", true);
    }
    
    $total = get_cart_total(&$_SESSION['cart']);
    
    $amount =& Services_PayPal::getType('BasicAmountType');
    $amount->setval($total);
    $amount->setattr('currencyID', 'USD');

    $pdt =& Services_PayPal::getType('PaymentDetailsType');
    $pdt->setOrderTotal($amount);

    $details =& Services_PayPal::getType('DoExpressCheckoutPaymentRequestDetailsType');
    $details->setPaymentAction((@$_SESSION['authCapture']) ? "Authorization" : "Sale");
    $details->setToken($_SESSION['expressCheckoutToken']);
    $details->setPayerID($_SESSION['payerID']);
    $details->setPaymentDetails($pdt);

    $ecprt =& Services_PayPal::getType('DoExpressCheckoutPaymentRequestType');
    $ecprt->setDoExpressCheckoutPaymentRequestDetails($details);
    
    /* This would normally not be necessary, but since we are performing the call on the fly
       we need to write the data in the certificate file to the filesystem temporarily to perform
       the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage, true);
    }
    
    $result = $caller->DoExpressCheckoutPayment($ecprt);
    @unlink($filename);
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), false);
    }
    
    header("Location:  thankYou.php");
?>