<?php
    require_once '../lib/functions.inc.php';
    session_start();
    
    $bi = $_SESSION['billing_info'];
    
    $total = get_cart_total(&$_SESSION['cart']);
    
    $name =& Services_PayPal::getType('PersonNameType');
    $name->setFirstName($bi['firstName']);
    $name->setLastName($bi['lastName']);

    $address =& Services_PayPal::getType('AddressType');
    $address->setStreet1($bi['streetAddress1']);
    
    if(!empty($bi['streetAddress2'])) 
    {
        $address->setStreet2($bi['streetAddress2']);
    }
    
    $address->setCityName($bi['city']);
    $address->setStateOrProvince($bi['state']);
    $address->setCountry($bi['country']);
    $address->setPostalCode($bi['zipCode']);
    
    $payer =& Services_PayPal::getType('PayerInfoType');
    $payer->setPayer($_SESSION['emailAddress']);
    $payer->setPayerCountry($bi['country']);
    $payer->setAddress($address);
    $payer->setPayerName($name);

    $cc =& Services_PayPal::getType('CreditCardDetailsType');
    $cc->setCreditCardType($_cc_descriptions[$bi['method']]);
    $cc->setCreditCardNumber($bi['creditCardNumber']);
    $cc->setExpMonth($bi['expirationMonth']);
    $cc->setExpYear($bi['expirationYear']);
    $cc->setCardOwner($payer);

    $amount =& Services_PayPal::getType('BasicAmountType');
    $amount->setval($total);
    $amount->setattr('currencyID', 'USD');

    $pdt =& Services_PayPal::getType('PaymentDetailsType');
    $pdt->setOrderTotal($amount);

    $details =& Services_PayPal::getType('DoDirectPaymentRequestDetailsType');
    $details->setPaymentAction((@$_SESSION['authCapture']) ? "Authorization" : "Sale");
    $details->setPaymentDetails($pdt);
    $details->setCreditCard($cc);
    $details->setIPAddress($_SERVER['REMOTE_ADDR']);
    $details->setMerchantSessionId(null);

    $ddp =& Services_PayPal::getType('DoDirectPaymentRequestType');
    $ddp->setDoDirectPaymentRequestDetails($details);

    /* This would normally not be necessary, but since we are performing the call on the fly
       we need to write the data in the certificate file to the filesystem temporarily to perform
       the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {
        @unlink($filename);
        do_error($caller->getMessage());
    }

    $result = $caller->DoDirectPayment($ddp);
    @unlink($filename);
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), false);
    }
    
    switch($result->Ack)
    {
        case "Success":
            $_SESSION['cart'] = new ShoppingCart();
            header("Location: thankYou.php");
            break;
        case "Failure":
            do_error($result->Errors->ShortMessage, false);
            break;
        default:
            do_error("Unknown Acknowledgement: {$result->Ack}", true);
            break;
    }
    
?>