<?php
    require_once '../lib/functions.inc.php';
    session_start();
    $_info_box = "This page represents the result of the <code>TransactionSearch</code> API. The hyperlinked Order ID initiates a <code>GetTransactionsDetails</code> API.";
    
    $_SESSION['productDesc'] = "Order Admin Area";
    
    /* This would normally not be necessary, but since we are performing the call on the fly
    we need to write the data in the certificate file to the filesystem temporarily to perform
    the request */
    
    $filename = tempnam(null, null);
    $fr = fopen($filename, "w");
    fputs($fr, $_SESSION['certFileContents']);
    fclose($fr);
    
    $_SESSION['APIProfile']->setCertificateFile($filename);
    
    $caller =& Services_PayPal::getCallerServices($_SESSION['APIProfile']);
    
    if(Services_PayPal::isError($caller))
    {   
        @unlink($filename);
        do_error($caller->getMessage(), true);
    }
    
    $ts =& Services_PayPal::getType('TransactionSearchRequestType');
    $ts->setStartDate(date('Y-m-d', mktime(0,0,0,1,1,date('Y'))) . 'T00:00:00-0700');    
    
    $result = $caller->TransactionSearch($ts);
    @unlink($filename);
    
    if(Services_PayPal::isError($result))
    {
        do_error($result->getMessage(), true);
    }   
    
    switch($result->Ack)
    {
        case "Success":
            break;
        case "Failure":
            do_error($result->Errors->ShortMessage, false);
            break;
        default:
            do_error("Unknown Response Type", true);
    }
    
    include_once '../lib/html/header.html.php';
?>
<table cellpadding="0" cellspacing="0" border="0" width="750">
<tr>
<td>

	<table cellpadding="0" cellspacing="0" border="0" width="752" class="content">
	<tr>
	<td>
		
		<img src="../images/spacer.gif" width="1" height="325" align="right" />

		<p class="title">Orders</p>
		<p>Click on the Order ID to view the details of the order.</p>

		<table cellpadding="6" cellspacing="0" border="0" width="100%" class="tbl">
		<thead>
		<tr>
		<th><p>Date</p></th>
		<th><p>&nbsp;</p></th>

		<th><p class="i">Order ID</p></th>
		<th><p>&nbsp;</p></th>
		<th><p>Customer</p></th>
		<th><p>&nbsp;</p></th>
		<th><p>&nbsp;</p></th>
		<th><p align="center">Order Total</p></th>

		<th><p>&nbsp;</p></th>
		<th><p>Status</p></th>
		</tr>
		</thead>
		
<?php 
    $show_info = true;
    $ordernum = 100;
    foreach($result->PaymentTransactions as $trans): 
      $date = date('m-d-Y', strtotime($trans->Timestamp));
?>
		<tr>
		<td><p><?php print $date; ?></p></td>
		<td><p>&nbsp;</p></td>
		<td>
		<p class="i">
		<?php if($show_info): ?>
		<img src="../images/i_sm.gif" width="18" height="18" alt="" border="0" align="absmiddle" class="i"/>
		<?php $show_info = false; endif; ?>
		
		<?php if($trans->Status != "Pending"): ?>
		<a href="viewOrderDetails.php?transID=<?php print $trans->TransactionID; ?>&orderID=<?php print $ordernum; ?>"><?php print $ordernum; ?></a>
		<?php else:
		      print $ordernum;
		      endif;
		?>
	    
		</p></td>

		<td><p>&nbsp;</p></td>
		<td><p><?php print $trans->PayerDisplayName; ?></p></td>
		<td><p>&nbsp;</p></td>
		<td><p>&nbsp;</p></td>
		<td><p align="center">$<?php print $trans->GrossAmount->_value; ?></p></td>
		<td><p>&nbsp;</p></td>

		<td><p><?php print $trans->Status; ?></p></td>
<?php $ordernum++; endforeach; ?>
		</table>
	</td>
	</tr>
	</table>
</td>
</tr>
</table>
<?php include_once '../lib/html/footer.html.php'; ?>