<?php
    require_once 'Services/PayPal.php';
    require_once 'Services/PayPal/Profile/API.php';
    require_once 'Services/PayPal/Profile/Handler/Array.php';
    require_once 'ShoppingCart.class.php';

    require_once 'photo_data.inc.php';
    require_once 'app_data.inc.php';
    
    function html_var_dump($var)
    {
        print "<PRE>";
        var_dump($var);
        print "</PRE>";
    }
    
    function get_url()
    {
        $retval = "http://{$_SERVER['SERVER_NAME']}";
        
        if($_SERVER['SERVER_PORT'] != 80)
        {
            $retval .= ":{$_SERVER['SERVER_PORT']}";
        }
        
        $retval .= dirname($_SERVER['PHP_SELF'])."/";
        return $retval;
    }
    
    function do_error($message, $halt = true)
    {
        @session_start();
        $_SESSION['error_msg'] = strip_tags($message);
        header("Location: error.php?halt=$halt");
        exit;
    }
    
    function get_cart_total(&$cart)
    {
        global $_photo_data;
        $total = 0;
        
        foreach($cart->getItems() as $itemID => $quantity)
        {
            $total += $_photo_data[$itemID]['price'] * $quantity;
        }
        
        return $total;
    }
?>