<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: main.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'lib/functions.inc.php';

session_start();

if(empty($_SESSION['pphandler']) ||
   empty($_SESSION['pphandler_params']))
{
    trigger_error("Unknown Profile Handler or missing parameters", E_USER_ERROR);
    exit;
}

$handlerinst = &_getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

if(Services_PayPal::isError($handlerinst))
{
    trigger_error($handlerinst->getMessage(), E_USER_ERROR);
    exit;
}

if(isset($_GET['profile_type']) &&
   isset($_GET['action']))
{
    switch($_GET['profile_type'])
    {
        case "API":
            $prefix = "api_";
            break;
        case "EWP":
            $prefix = "ewp_";
            break;
    }

    $location = null;

    switch($_GET['action'])
    {
        case "Create New Profile":
            $location = $prefix . "create.php";
            break;

        case "Delete":

            $cert_save_path = _getProfileCertSavePath();

            if(Services_PayPal::isError($cert_save_path))
            {
                trigger_error("Could not delete: ". $cert_save_path->getMessage());
                exit;
            }

            $cert_file = "$cert_save_path/{$_GET['pid']}.cert";
            $pkey_file = "$cert_save_path/{$_GET['pid']}.prv";

            @unlink($cert_file);
            @unlink($pkey_file);

            $result = $handlerinst->deleteProfile($_GET['pid']);

            if(Services_PayPal::isError($result))
            {
                trigger_error($result->getMessage());
                exit;
            }
            break;

        case "Edit":
            $location = $prefix . "edit.php?pid={$_GET['pid']}";
            break;

        case 'Call API':
            $_SESSION['apiprofile'] = $_GET['pid'];
            $location = 'WebTester/index.php';
            break;

        case 'Generate Button':
            $_SESSION['ewpprofile'] = $_GET['pid'];
            $location = 'ewp_button.php';
            break;

        default:
            trigger_error("Invalid action type", E_USER_ERROR);
            exit;
    }

    if(!is_null($location))
    {
        header("Location:  $location");
        exit;
    }
}

$profile_ids = $handlerinst->listProfiles();

if(Services_PayPal::isError($profile_ids))
{
    trigger_error($profile_ids->getMessage(), E_USER_ERROR);
    exit;
}

foreach($profile_ids as $pid)
{
    $profiledata = $handlerinst->loadProfile($pid);

    switch(strtolower($profiledata['classname']))
    {
        case 'apiprofile':
            $api_profile_ids[$pid] = $profiledata;
            break;
        case 'ewpprofile':
            $ewp_profile_ids[$pid] = $profiledata;
            break;
    }
}

require_once 'pages/main.html.php';
?>
