<?php
include 'ppsdk_include_path.inc';

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/Handler/Array.php';
require_once 'Services/PayPal/Profile/API.php';
require_once 'Services/PayPal/Type/DoVoidRequestType.php';
require_once 'SampleLogger.php';
require_once 'lib/constants.inc.php';

session_start();

$was_submitted = false;

$logger = new SampleLogger('VoidReceipt.php', PEAR_LOG_DEBUG);
$logger->_log('POST variables: '. print_r($_POST, true));

$profile = $_SESSION['APIProfile'];

// Verify that user is logged in
if(! isset($profile)) {
   // Not logged in -- Back to the login page
   // TBD:  Continue using sdk-seller?
   $logger->_log('You are not logged in;  return to index.php'); 
   $location = 'index.php';
   header("Location: $location"); 
} else {
   $logger->_log('Profile from session: '.print_r($profile, true)); 
}

// Build our request from $_POST
$void_request =& Services_PayPal::getType('DoVoidRequestType');
if (Services_PayPal::isError($void_request)) {
   $logger->_log('Error in request: '. $void_request);    
} else {
   $logger->_log('Create request: '. $void_request);
}

// Set request fields
$authorization_id = $_POST['authorization_id'];
if(isset($authorization_id)) {
   $void_request->setAuthorizationID($authorization_id, 'iso-8859-1'); 
} 
$note = $_POST['note'];
if(isset($note))
   $void_request->setNote($note);

$logger->_log('Initial request: '. print_r($void_request, true));

$caller =& Services_PayPal::getCallerServices($profile);

$response = $caller->DoVoid($void_request);

$ack = $response->getAck();

$logger->_log('Ack='.$ack);

switch($ack) {
   case ACK_SUCCESS:
   case ACK_SUCCESS_WITH_WARNING:
      // Good to break out;
      break;
   
   default:
      $_SESSION['response'] = $response;   
      $logger->_log('DoVoid failed: ' . print_r($response, true));
      $location = "ApiError.php";
      header("Location: $location");  
}

// Otherwise, load the HTML response
require_once 'pages/VoidReceipt.html.php';

?>