<?php
/********************************************************************
*	Hotspot Authentication, Authorization and Accounting System
*
*	Module: 	configure-inc.php
*	Function:	Setup environment
*
*	2005-09-04 Gunther Richter - Ultra Consulting Network Limited
*
*********************************************************************/

ini_set('register_globals', '0');
ini_set('magic_quotes_gpc', '0');
ini_set('max_execution_time', '600'); // maximum execution time for script

define ('PHS_LOG_FILE', 'logs/phs.log');

require('includes/database_tables-inc.php');
require('Smarty/libs/Smarty.class.php');
require('Smarty/libs/SmartyMenu.class.php');
//require_once('Auth/Auth.php');
require_once('Auth.php');
require_once('includes/filenames-inc.php');	// all PHP filenames

// Refer to Changelog.txt for further version changes
//define ('PHS_VERSION', 'v1.0.2'); // initial version
//define ('PHS_VERSION', 'v1.0.3'); // 20060210gr useredit start/stop date/time changed
//define ('PHS_VERSION', 'v1.0.4'); // 20060217gr user & client logging added
//define ('PHS_VERSION', 'v1.0.5'); // 20060221gr profile added
//define ('PHS_VERSION', 'v1.0.6'); // 20060223gr system settings,TZ,Lang,countryCode added
//define ('PHS_VERSION', 'v1.0.7'); // 20060225gr operator administration added
//define ('PHS_VERSION', 'v1.0.8'); // 20060227gr PHPLivesupport added
//define ('PHS_VERSION', 'v1.0.9'); // 20060301gr operator admin cont.
//define ('PHS_VERSION', 'v1.1.0'); // 20060305gr Network device monitoring added
//define ('PHS_VERSION', 'v1.1.1'); // 20060308gr no more up.acl, only alive.acl
//define ('PHS_VERSION', 'v1.1.2'); // 20060312gr prepaid activated, login Id field exp.
//define ('PHS_VERSION', 'v1.1.3'); // 20060312gr prepaid useredit
//define ('PHS_VERSION', 'v1.1.5'); // 20060316gr prepaid card file storage functionality
//define ('PHS_VERSION', 'v1.1.6'); // 20060319gr rewrite of getAllUsers function, 
                                  // Add Expired cards menu item, sort displ. enhanced
//define ('PHS_VERSION', 'v1.1.7'); // 20060326gr add admin overview
//define ('PHS_VERSION', 'v1.1.8'); // 20060331gr add userreport
//define ('PHS_VERSION', 'v1.1.9'); // 20060402gr userreport expanded, prepaid minor mods
//define ('PHS_VERSION', 'v1.2.0'); // 20061125gr accounting incl. prepaid added
//define ('PHS_VERSION', 'v1.2.1'); // 20070515gr billing for non-prepaid added
//define ('PHS_VERSION', 'v1.2.2'); // 20070522gr Add Disconnect User (only from rad01)
//define ('PHS_VERSION', 'v1.2.3'); // 20070628gr Accounting Report using GET
//define ('PHS_VERSION', 'v1.2.4'); // 20070717gr Reporting periods corrected
//define ('PHS_VERSION', 'v1.2.5'); // 20071010gr ShowPW, ueredit field seq. changed to avoid losing password when changing Internet Service Plan, Add Accounting to PowerUser permission
//define ('PHS_VERSION', 'v1.2.6'); // 20080219gr DB failover added
//define ('PHS_VERSION', 'v1.2.7'); // 20080724gr suppress showing of billing cycle for Free Plans
//define ('PHS_VERSION', 'v1.2.8'); // 20080803 MULTISITE option to display phs gateway name
//define ('PHS_VERSION', 'v1.2.9'); // 20080825 Added Help page and operator guide
//define ('PHS_VERSION', 'v1.3.0'); // 20080914 ticket printer support (Kapok)
//define ('PHS_VERSION', 'v1.3.1'); // 20081030 Routerset.php, MAC restriction for prepaid
//define ('PHS_VERSION', 'v1.3.2'); // 20081108 disconnect user using mysql UDF
//define ('PHS_VERSION', 'v1.3.3'); // 20081115 show currency in useradd and useredit
//define ('PHS_VERSION', 'v1.3.4'); // 20081116 enable online payments
//define ('PHS_VERSION', 'v1.3.5'); // 20081121 bug fixes for user status, several cleanups
define ('PHS_VERSION', 'v1.3.6'); // 20110708 add expiry date for prepaid tickets and getReplyMessage function

// User data lenght validation
// ... should be selectable in admin menu
define ('PHS_LEN_PW', 5);               // min password length
define ('PHS_LEN_PW_MAX', 20);          // max password length
define ('PHS_LEN_USER', 3);             // min username lenght
define ('PHS_LEN_USER_MAX', 20);        // max username lenght
define ('PHS_LEN_LOCATION', 1);         // min location/room len
define ('PHS_LEN_LOCATION_MAX', 30);    // max location/room len
define ('PHS_LEN_FIRSTNAME', 2);
define ('PHS_LEN_FIRSTNAME_MAX', 32);
define ('PHS_LEN_LASTNAME', 2);
define ('PHS_LEN_LASTNAME_MAX', 48);
define ('PHS_LEN_EMAIL ', 6);
define ('PHS_LEN_EMAIL_MAX ', 48);

define ('PHS_DATE', 'd-M-Y');	// date format
define ('PHS_FDATE', 'ymd');	// yymmdd format
define ('PHS_4FDATE', 'Ymd');	// yyyymmdd format
define ('PHS_TIME', 'h:i a');	// date format
define ('PHS_DATETIME', 'd-M-Y h:ia');	// date and time format
define ('PHS_ISODATE', 'Y-m-d');	// ISO date format
define ('PHS_ISODATETIME', 'Y-m-d H:i:s');	// ISO 9075 date/time format
define ('PHS_ISO8601', 126);	// MS-SQL ISO 8601 format 'yyyy-mm-dd Thh:mm:ss.mmm(no spaces)'

	// database wide flags for all tables
define ('PHS_ST_INACTIVE', 0);	  // normal status
define ('PHS_ST_ACTIVE', 1);	    // either offline or online
define ('PHS_ST_SUSPENDED', 2);	  //
define ('PHS_ST_IDLE_TIMEOUT', 4);//
define ('PHS_ST_EXPIRED', 8);		  //
define ('PHS_ST_PENDING', 16);		// start in future
define ('PHS_ST_READY', 32);      // ready for login
define ('PHS_ST_PREPAID', 64);    // this is a prepaid card
define ('PHS_ST_DEL', 128);		    // row status: marked as deleted

define ('PHS_ST_LOGINREADY', 323232);      // return from getUserStatus and getAllUsers when user was not yet logged in

define ('PHS_STP_ALL', 1);  // Search Type: show ALL records

define ('PHS_DB_COMMIT', 0);    // allow commit when doing nested db calls
define ('PHS_DB_NO_COMMIT', 2); // supress commit when doing nested db calls

	// database flags for alterations
define ('PHS_ALT_STD', 1);	// standard alterations
define ('PHS_ALT_NOSTD', 2);	// non-standard alterations
define ('PHS_ALT_ZERO', 127);	// zero alteration value to allow the value 0
                                // note: value for tinyint (range different in MySQL)

define ('PHS_PW_DUMMY', '___0__'); // dummy filler for form input fields

define ('PHS_PRINT_LABEL_MAXL', 10); // max number of chars for printed labels

define ('BRANCH_HEAD_OFFICE', 0);	// Branch Type for DB com_branch table
define ('BRANCH_OFFICE', 1);	// Branch Type for DB com_branch table

// Company address for order form
define ('COMPANY_NAME_LG', 'w w w . p o i n t H o t s p o t . c o m');
define ('COMPANY_ADDRESS_1', 'P.O. Box 1524');
define ('COMPANY_CITY', 'Port of Spain');
define ('COMPANY_COUNTRY', 'Trinidad, West Indies');
define ('COMPANY_PHONE', '(868) 628-9196');
define ('COMPANY_FAX', '(868) 628-3219');

define ('COMPANY_NAME', 'Ultra Consulting Network Ltd');

define ('PHS_COUNTRY', 'TT'); // default country code

// Database Table values
  // usergroup table groupname for 'suspended' -> rejected users
define('PHS_RADGRP_SUSPENDED', 'reject-group');
define('PHS_RAD_COAPORT', 3799); // RADIUS disconnect port
//define('PHS_RADCLIENT', '/usr/bin/radclient'); // RADIUS disconnect port
define('PHS_RADCLIENT', '/usr/local/bin/radclient'); // RADIUS disconnect port
define('PHS_RAD_DISCONNECT', 40); // RADIUS disconnect command
define('PHS_RAD_DISCONNECT_LOG', '/var/lib/mysql/radDisc.log' ); // RADIUS disconnect log

// client options 32 bit flags masks
define ('PHS_M_CLIENT_TIME24', 0x1);    // if set, display 24h instead of 12h 
define ('PHS_M_CLIENT_SUSPEND', 0x2);   // if set, user can be actively suspended via port 3799
define ('PHS_M_CLIENT_SHOWPW', 0x4);   // if set, user passwords are shown
define ('PHS_M_CLIENT_ADVANCED', 8);  // user/operator is intermediate
define ('PHS_M_CLIENT_EXPERT', 16);  // user/operator is expert
define ('PHS_M_CLIENT_NEXT', 32);  // future level
define ('PHS_M_CLIENT_BILLING', 64);  // enable billing cycle and billing recording
define ('PHS_M_CLIENT_MULTISITE', 128);  // show multiple sites under same management
define ('PHS_M_CLIENT_MACRESTRICT', 256);  // Allow clients with this MAC address only
define ('PHS_M_CLIENT_ONLPAYMENT', 512);  // enable online payment

// package type options 32 bit flags masks in package_type table
define ('PHS_M_PACKT_START', 0x1);    // if set, use user starttime
define ('PHS_M_PACKT_STOP', 0x2);    // if set, use user stoptime
define ('PHS_M_PACKT_TOTAL', 0x4);    // if set, use user accounting total = prepaid
define ('PHS_M_PACKT_ALL', 0x1024);    // if set, use all user accounting packages

define ('PHS_RADSERVER01', 'rad01.pointhotspot.com'); // first radius server
define ('PHS_RADSERVER02', 'rad02.pointhotspot.com'); // second radius server
define ('PHS_RAD_IDLE_TIMEOUT', 3600); // set in ./raddb/users
define ('PHS_RAD_ONLINE_TIMEOUT', 600); // seconds after user is guessed offline

  // client log (not a bitfield, but error numbers)
define ('PHS_LOGACT_LOGIN', 1);
define ('PHS_LOGACT_LOGOUT', 2);
define ('PHS_LOGACT_LOGINFAIL', 4);
define ('PHS_LOGACT_LOGINATT', 5); // login attempt for disabled account

  // user log for each change in the phs_user table, not a bit field
define ('PHS_LOGUS_INSERT', 1); // user insert
define ('PHS_LOGUS_UPDATE', 2); // user update
define ('PHS_LOGUS_IFAILED', 4); // user insert failed
define ('PHS_LOGUS_UFAILED', 8); // user update failed
define ('PHS_LOGUS_DFAILED', 16); // user delete failed
define ('PHS_LOGUS_CCINSERT', 17); // client contact insert
define ('PHS_LOGUS_CCUPDATE', 18); // client contact update
define ('PHS_LOGUS_CCIFAILED', 19); // client contact insert failed
define ('PHS_LOGUS_CCDELETE', 20); // client contact delete
define ('PHS_LOGUS_CCDFAILED', 21); // client contact delete failed
define ('PHS_LOGUS_DELETE', 128);

// Network Device Monitoring
define ('PHS_NDEV_TOUT_LIMIT', 1800); // set warning timeout level to 1800 seconds

// Prepaid card directory
//define ('PHS_PREPAID_DIR', '../../phsc/'); now in ../45 dir

define ('PPCARD_TYPE_INUSE', 1);
define ('PPCARD_TYPE_UNUSED', 2);
define ('PPCARD_TYPE_EXPIRED', 3);
define ('PPCARD_TYPE_ALL', 4);

// Billing cycles 20070514
define ('PHS_BILLING_NONE', 0);   // no cycle selected
define ('PHS_BILLING_NEW', 1);    // new cycle for user
define ('PHS_BILLING_EXT', 2);    // extend cycle for same user
define ('PHS_BILLING_NOBILL', 3); //  non billable (for password and other changes)
define ('PHS_BILLING_AUTO', 4);   // automatic billing (future)
define ('PHS_BILLING_REFUND', 5); // refund amount
define ('PHS_BILLING_FREE', 6);   // True if billing amount is zero

// logout for wifi users from phs website
define ('PHS_LOGOFF_182', 'http://192.168.182.1:3990/logoff');

// 20080220 (mokpa.pair.com path)
define ('PHS_GEOIP_DB_PATH', '/home/www/GeoIP/GeoIP.dat');

// FPDF path
define('FPDF_PATH','fpdf153/'); // path to FPDF
define('FPDF_FONTPATH','fpdf153/font/'); // path to FPDF Fonts

define ('PHS_LIVE_SUPPORT_BASEURL', 'http://support.pointhotspot.com/live');
define ('PHS_LIVE_SUPPORT_BASEURL_HTTPS', 'https://secure.pointhotspot.com/live');

?>
