<?php

//
// Edit History:
//
//  Last $Author: munroe $
//  Last Modified: $Date: 2006/04/06 23:21:54 $
//
//  Dick Munroe (munroe@csworks.com) 28-Feb-2006
//      Initial version created
//

/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ 2006 by Dick Munroe, Cottage Software Works, Inc.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package dm.paypal
 * @example ./example.php
 *
 * This is derived from a paypal IPN class written originally by Herve Foucher
 * <Herve.Foucher@helio.org> and published through phpclasses.org under the GPL.
 * Herve appears to no longer support this package so I'm updating the support
 * to 1.6 and redesigning a bunch of the internal structure to allow a substantially
 * more object oriented approach to the whole problem.
 *
 * This object captures the IPN Buyer Information as given in table 4.3 of the
 * Order Management Integration Guide.
 */

include_once('class.paypalIPNDataBase.php') ;

class paypalIPNBuyerInformation extends paypalIPNDataBase
{
    var $address_city ;
    var $address_country ;
    var $address_country_code ;
    var $address_name ;
    var $address_state ;
    var $address_status ;
    var $address_street ;
    var $address_zip ;
    var $first_name ;
    var $last_name ;
    var $payer_business_name ;
    var $payer_email ;
    var $payer_id ;
    var $payer_status ;
    var $residence_country ;

    /**
     * @desc Buyer information constructor
     * @param array $theSource [by reference] post data of the IPN.
     */

    function paypalIPNBuyerInformation(&$theSource)
    {
	$this->paypalIPNDataBase($theSource) ;
    }
}
?>