<?php  
    require_once("lib/functions.inc.php");

    session_start();
    
    function do_form_error($msg, $url)
    {
        $_SESSION['error_msg'] = $msg;
        header("Location: $url");
        exit;
    }
   
    if(empty($_POST))
    {
        do_form_error("You must login first!", "start_demo.php");
    }

    if(empty($_POST['emailAddress']))
    {
        do_form_error("The E-mail address is required", "start_demo.php");
    }
    
    $_SESSION['emailAddress'] = strip_tags($_POST['emailAddress']);
    
    if(empty($_POST['apiUsername']))
    {
        do_form_error("You must provide an API Username", "start_demo.php");
    }
    
    $_SESSION['apiUsername'] = strip_tags($_POST['apiUsername']);
    
    if(empty($_POST['apiPassword']))
    {
        do_form_error("You must provide an API Password", "start_demo.php");   
    }

    if(!is_array($_FILES['certFile']) ||
       !is_uploaded_file($_FILES['certFile']['tmp_name']))
    {
        $_SESSION['certFile'] = $_FILES['certFile']['name'];
        do_form_error("You must provide a certificate file.\nEither the certificate file was not provided or was invalid.",
                      "start_demo.php");
    }

    $_SESSION['certFile'] = $_FILES['certFile']['name'];
    $_SESSION['certFileContents'] = file_get_contents($_FILES['certFile']['tmp_name']);
    
    $handler =& ProfileHandler_Array::getInstance(array(
        'username' => $_SESSION['apiUsername'],
        'certificateFile' => null,
        'subject' => null,
        'environment' => "Sandbox"));

    $id = $handler->generateID();

    $profile =& APIProfile::getInstance($id, $handler);
    $profile->setAPIPassword($_POST['apiPassword']);

    $_SESSION['APIProfile'] = $profile;
    header("Location:  home.php");    
?>