<?php
    require_once 'lib/functions.inc.php';
    
    session_start();
    if(!isset($_GET['productID']) || !$_GET['productID'])
    {
        do_error("No product ID was specified");
    }
    
    $_SESSION['productID'] = (int)$_GET['productID'];
    $_SESSION['authCapture'] = isset($_GET['authCapture']);
    $_SESSION['currentCatID'] = 0;
    $_SESSION['cart'] = new ShoppingCart();
    
    switch($_SESSION['productID'])
    {
        case 1:
            $_SESSION['productDesc'] = "A demonstration of PayPal's Website Payments Standard flow";
            break;
        case 2:
            if(!$_SESSION['authCapture'])
                $_SESSION['productDesc'] = "A demonstration of PayPal's Direct Payment API flow";
            else 
                $_SESSION['productDesc'] = "A demonstration of PayPal's Direct Payment API with Authorization & Capture flow";
            break;
        case 3:
            if(!$_SESSION['authCapture'])
                $_SESSION['productDesc'] = "A demonstration of PayPal's Express Checkout flow";
            else 
                $_SESSION['productDesc'] = "A demonstration of PayPal's Express Checkout with Authorization & Capture flow";
            break;
        case 4:
            $_SESSION['productDesc'] = "A demonstration of PayPal's PayPal as an Additional Payment Option flow";
            break;
        default:
            $_SESSION['productDesc'] = "Product Not described yet FIX ME";
    }
    
    header("Location: app/home.php");
?>