<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: api_edit.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/API.php';
require_once 'Services/PayPal/Profile/Handler.php';
require_once 'lib/api_form_validators.inc.php';
require_once 'lib/functions.inc.php';

session_start();

$dummy= @new APIProfile();
$environments = $dummy->getValidEnvironments();

$was_submitted = false;

$errors = array();

if(isset($_POST['submitted']))
{
    unset($_POST['submitted']);
    unset($_POST['action']);
    unset($_POST['certificate_file']);

    $was_submitted = true;

    $errors = validate_form_input($_POST);

    $cert_save_path = _getProfileCertSavePath();

    if(Services_PayPal::isError($cert_save_path))
    {
        $errors['unknown'][] = $cert_save_path->getMessage();
    }

    if(empty($errors))
    {
        $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

        if(!Services_PayPal::isError($handlerinst))
        {
            $pid = $_POST['pid'];
            $profile = APIProfile::getInstance($pid, $handlerinst);

            if(!Services_PayPal::isError($profile))
            {
                if(!empty($_FILES['new_certificate_file']['tmp_name']))
                {
                    $save_file = "$cert_save_path/$pid.cert";

                    if(!@move_uploaded_file($_FILES['new_certificate_file']['tmp_name'],
                                           $save_file))
                    {
                        $errors['unknown'][] = "Could not store uploaded certificate '{$_FILES['new_certificate_file']['tmp_name']}'";
                    }

                    $profile->setCertificateFile($save_file);
                }

                $profile->setAPIUsername($_POST['api_username']);
                $profile->setSubject($_POST['api_subject']);
                $profile->setEnvironment($_POST['environment']);

                $result = $profile->save();

                if(Services_PayPal::isError($result))
                {
                    $errors['unknown'][] = "Could not create new profile: ".$result->getMessage();
                }
            }
            else
            {
                $errors['unknown'][] = "Could not create a new instance of APIProfile: ".$profile->getMessage();
            }
        }
        else
        {
            $errors['unknown'][] = "Could not create a new Profile Handler: ". $handlerinst->getMessage();
        }

    }
}

if(!isset($handlerinst) || !is_a($handlerinst, "ProfileHandler"))
{
    $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);
}

if(Services_PayPal::isError($handlerinst))
{
    $errors['unknown'][] = "Could not get a valid Profile Handler, can't edit: ". $handlerinst->getMessage();
}
else
{
    $data = $handlerinst->loadProfile($_REQUEST['pid']);

    if(Services_PayPal::isError($data))
    {
        $errors['unknown'][] = "Could not load the profile's data: ". $data->getMessage();
    }
}

require_once "pages/api_edit.html.php";
