<?php
/**
 * GUI Profile Admin Tool
 *
 * $Id: ewp_edit.php,v 1.1.1.1 2006/02/19 08:15:20 dennis Exp $
 *
 * @package Services_PayPal
 */

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/EWP.php';
require_once 'Services/PayPal/Profile/Handler.php';
require_once 'lib/ewp_form_validators.inc.php';
require_once 'lib/functions.inc.php';

session_start();

$dummy= @new EWPProfile();
$environments = $dummy->getValidEnvironments();

$was_submitted = false;
$errors = array();

if(isset($_POST['submitted']))
{
    unset($_POST['submitted']);
    unset($_POST['action']);

    $was_submitted = true;

    $errors = validate_form_input($_POST);

    if(isset($_FILES['new_certificate_file']) &&
       file_exists($_FILES['new_certificate_file']['tmp_name']))
    {
        if(!is_uploaded_file($_FILES['new_certificate_file']['tmp_name']))
        {
            $errors['new_certificate_file'] = "Invalid file upload, cannot save profile";
        }
    }

    if(isset($_FILES['new_privatekey']) &&
       file_exists($_FILES['new_privatekey']['tmp_name']))
    {
        if(!is_uploaded_file($_FILES['new_privatekey']['tmp_name']))
        {
            $errors['new_privatekey'] = "Invalid file upload for private key, cannot save profile";
        }
    }

    $cert_save_path = _getProfileCertSavePath();

    if(Services_PayPal::isError($cert_save_path))
    {
        $errors['unknown'][] = $cert_save_path->getMessage();
    }

    if(empty($errors))
    {
        $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);

        if(!Services_PayPal::isError($handlerinst))
        {
            $profile = EWPProfile::getInstance($_POST['pid'], $handlerinst);

            if(!Services_PayPal::isError($profile))
            {
                if(isset($_FILES['new_certificate_file']) &&
                   file_exists($_FILES['new_certificate_file']['tmp_name']))
                {
                    $save_file = "$cert_save_path/{$_POST['pid']}.cert";
                    if(!move_uploaded_file($_FILES['new_certificate_file']['tmp_name'],
                                           $save_file))
                    {
                        $errors['unknown'][] = "Could not store uploaded certificate '{$_FILES['certificate_file']['tmp_name']}'";
                    }
                    else
                    {
                        $profile->setCertificateFile($save_file);
                    }
                }

                if(isset($_FILES['new_privatekey']) &&
                   file_exists($_FILES['new_privatekey']['tmp_name']))
                {
                    $save_file = "$cert_save_path/{$_POST['pid']}.prv";
                    if(!move_uploaded_file($_FILES['new_privatekey']['tmp_name'],
                                           $save_file))
                    {
                        $errors['unknown'][] = "Could not store uploaded private key '{$_FILES['certificate_file']['tmp_name']}'";
                    }
                    else
                    {
                        $profile->setPrivateKeyFile($save_file);
                    }
                }

                if(empty($errors))
                {
                    $profile->setButtonImage($_POST['buttonImageURL']);
                    $profile->setUrl($_POST['buttonURL']);
                    $profile->setCertificateId($_POST['cert_id']);
                    $profile->setEnvironment($_POST['environment']);

                    $result = $profile->save();

                    if(Services_PayPal::isError($result))
                    {
                        $errors['unknown'][] = "Could not create new profile: ".$result->getMessage();
                    }
                }
            }
            else
            {
                $errors['unknown'][] = "Could not get instance of profile to modify: ".$profile->getMessage();
            }
        }
        else
        {
            $errors['unknown'][] = "Could not create a new Profile Handler: ". $handlerinst->getMessage();
        }

    }
}
else
{

    if(!isset($handlerinst) || !is_a($handlerinst, "ProfileHandler"))
    {
        $handlerinst =& _getHandlerInstance($_SESSION['pphandler'], $_SESSION['pphandler_params']);
    }

    if(Services_PayPal::isError($handlerinst))
    {
        $errors['unknown'][] = "Could not get a valid Profile Handler, can't edit: ". $handlerinst->getMessage();
    }
    else
    {
        $data = $handlerinst->loadProfile($_REQUEST['pid']);

        if(Services_PayPal::isError($data))
        {
            $errors['unknown'][] = "Could not load the profile's data: ". $data->getMessage();
        }
    }
}

require_once "pages/ewp_edit.html.php";
