<?
include 'ppsdk_include_path.inc';

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/Handler/Array.php';
require_once 'Services/PayPal/Profile/API.php';
require_once 'Services/PayPal/Type/RefundTransactionRequestType.php';
require_once 'Services/PayPal/Type/RefundTransactionResponseType.php';
require_once 'lib/constants.inc.php';
require_once 'SampleLogger.php';

session_start();

$was_submitted = false;

$logger = new SampleLogger('RefundReceipt.php', PEAR_LOG_DEBUG);
$logger->_log('POST variables: '. print_r($_POST, true));

$profile = $_SESSION['APIProfile'];
// $caller = $_SESSION['caller'];

// Verify that user is logged in
if(! isset($profile)) {
   // Not logged in -- Back to the login page
   // TBD:  Continue using sdk-seller?
   $logger->_log('You are not logged in;  return to index.php'); 
   $location = 'index.php';
   header("Location: $location"); 
} else {
   $logger->_log('Profile from session: '.print_r($profile, true)); 
}

// Build our request from $_POST
// $refund_request = new TransactionSearchRequestType();
$refund_request =& Services_PayPal::getType('RefundTransactionRequestType');
if (Services_PayPal::isError($refund_request)) {
   $logger->_log('Error in request: '. $refund_request);    
} else {
   $logger->_log('Create request: '. $refund_request);
}
/*
// Generated code from WebConsole.
$Amount =& Services_PayPal::getType('BasicAmountType');
$Amount->setattr('currencyID', 'USD');
$Amount->setval('60', 'iso-8859-1');
$RefundTransaction =& Services_PayPal::getType('RefundTransactionRequestType');
if (Services_PayPal::isError($RefundTransaction)) {
    var_dump($RefundTransaction);
    exit;
}

$RefundTransaction->setMemo('my memo', 'iso-8859-1');
$RefundTransaction->setAmount($Amount);
$RefundTransaction->setRefundType('Full', 'iso-8859-1');
$RefundTransaction->setTransactionID('33762516V1595041U', 'iso-8859-1');

$result = $caller->RefundTransaction($RefundTransaction);
*/

// Transaction ID is required
$tran_id = $_POST['transactionID'];
if(isset($tran_id)) {
   $refund_request->setTransactionId($tran_id, 'iso-8859-1'); 
} else {
   // Error: transaction ID is required
   $location = 'RefundTransaction.php';
   header("Location: $location");
}

// refundType is optional and must be translated
// amount is optional
$refundType = $_POST['refundType'];
if(isset($refundType)) {
   
   $refund_request->setRefundType($refundType, 'iso-8859-1');
   
   if(false === strcasecmp($refundType, REFUND_PARTIAL)) {  
      // Process amount for partial refund
      $amount = $_POST['amount'];
      if(isset($amount)) {
         $Amount =& Services_PayPal::getType('BasicAmountType');
         $Amount->setattr('currencyID', 'USD');
         $Amount->setval('60', 'iso-8859-1');
         $refund_request->setAmount($Amount);
      }
   }
}

// memo is optional
$memo = $_POST['memo'];
if(isset($memo)) {
   $refund_request->setTransactionId($tran_id, 'iso-8859-1'); 
}

$logger->_log('Initial request: '. print_r($refund_request, true));

$caller =& Services_PayPal::getCallerServices($profile);

$response = $caller->RefundTransaction($refund_request);

$ack = $response->getAck();

$logger->_log('Ack='.$ack);

switch($ack) {
   case ACK_SUCCESS:
   case ACK_SUCCESS_WITH_WARNING:
      // Good to break out;
      break;
   
   default:
      $_SESSION['response'] =& $response;   
      $logger->_log('RefundTransaction failed: ' . print_r($response, true));
      $location = "ApiError.php";
      header("Location: $location");  
}

// Otherwise, load the HTML response

require_once 'pages/RefundReceipt.html.php';

?>