<?php

include 'ppsdk_include_path.inc';

require_once 'Services/PayPal.php';
require_once 'Services/PayPal/Profile/Handler/Array.php';
require_once 'Services/PayPal/Profile/API.php';
require_once 'Services/PayPal/Type/GetTransactionDetailsRequestType.php';
require_once 'SampleLogger.php';
require_once 'lib/constants.inc.php';

session_start();

$was_submitted = false;

$logger = new SampleLogger('TransactionDetails.php', PEAR_LOG_DEBUG);
$logger->_log('POST variables: '. print_r($_POST, true));

$profile = $_SESSION['APIProfile'];

// Verify that user is logged in
if(! isset($profile)) {
   // Not logged in -- Back to the login page
   // TBD:  Continue using sdk-seller?
   $logger->_log('You are not logged in;  return to index.php'); 
   $location = 'index.php';
   header("Location: $location"); 
} else {
   $logger->_log('Profile from session: '.print_r($profile, true)); 
}

// Build our request from $_POST
// $trans_details = new TransactionSearchRequestType();
$trans_details =& Services_PayPal::getType('GetTransactionDetailsRequestType');
if (Services_PayPal::isError($trans_details)) {
   $logger->_log('Error in request: '. $trans_details);    
} else {
   $logger->_log('Create request: '. $trans_details);
}

// Set request fields
$tran_id = $_GET['transactionID'];
if(isset($tran_id)) {
   $trans_details->setTransactionId($tran_id, 'iso-8859-1'); 
} else {
   // Error: transaction ID was not set
   $location = 'GetTransactionDetails.php';
   header("Location: $location");
}


$logger->_log('Initial request: '. print_r($trans_details, true));

$caller =& Services_PayPal::getCallerServices($profile);

$response = $caller->GetTransactionDetails($trans_details);

$ack = $response->getAck();

$logger->_log('Ack='.$ack);

switch($ack) {
   case ACK_SUCCESS:
   case ACK_SUCCESS_WITH_WARNING:
      // Good to break out;
      break;
   
   default:
      $_SESSION['response'] = $response;   
      $logger->_log('GetTransactionDetails failed: ' . print_r($response, true));
      $location = "ApiError.php";
      header("Location: $location");  
}

// Otherwise, load the HTML response
require_once 'pages/TransactionDetails.html.php';

?>