<?php
/***************************************************************
*
*	Prepaid Cards
*	
*	2006-03-09 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

require('includes/init-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN+PHS_PERM_PUSER+PHS_PERM_USER);

$mainHeadline = 'Prepaid';
//$selectedServicePlan = -1;
$_cardArray = array();
$_planShort = '';
$searchstr = '';
$sortorder = '';
$remainingOnlineTime = 0;
$_tdWidth = '';
$_colSize = 0;
$timeOrderStr = 'dtime';
$typeOrderStr = 'dtype';

$a->setAuthData('Phs_NextPage', PHS_FILE_PREPAID);

$selectedServicePlan = (isset($Phs_POST['ServicePlanSelect']) ? $Phs_POST['ServicePlanSelect'] : -1);
if (($servicePlansArray = $dbc->getServicePlans($phs_client_info['client_id'], PHS_M_PACKT_TOTAL)) == Null) {
$Phs_ErrMsg = 'No Prepaid Service Plans assigned for this client';
} else {
  //print_r($servicePlansArray);
  $_phsOptionSelect = '';
  for ($ix=1; $ix < sizeof($servicePlansArray); $ix++) {
  //for ($ix=0; $ix < sizeof($servicePlansArray); $ix++) {
    if ($selectedServicePlan == -1) {   // select first/default package
      $selectedServicePlan = $servicePlansArray[$ix]['client_package_id'];
    } elseif ($selectedServicePlan == $servicePlansArray[$ix]['client_package_id']) {
      $_planShort = $servicePlansArray[$ix]['package_type_short'];
    }
    //switch($servicePlansArray[$ix]['package_type_options']) {
    //case ($servicePlansArray[$ix]['package_type_options'] & PHS_M_PACKT_TOTAL):
    //case (PHS_M_PACKT_TOTAL):
      //$smarty->assign('showStartTime', True);
      //print(' Acct ');
      $_phsOptionSelect .= '<option ';
      $_phsOptionSelect .= 'value="' . $servicePlansArray[$ix]['client_package_id'] . '">' . $servicePlansArray[$ix]['package_type_short'] . '</option>';
     // break;
    //}
  }
  $smarty->assign('phsOptionSelect', $_phsOptionSelect);
}

if (isset($Phs_GET['create'])) {
  $mainHeadline .= ' Card Creation';
  $smarty->assign('cardTask', 1); // create cards
    // request submitted
  if (isset($Phs_POST['numCards']) && isset($Phs_POST['ServicePlanSelect'])) {
    $selectedServicePlan = $Phs_POST['ServicePlanSelect'];
    $_userMacGroup = (isset($Phs_POST['macRestrict']) && $Phs_POST['macRestrict'] > 0 ? $Phs_POST['macRestrict'] : 0);
    //createAccountCards($numCards=0, $cardTime=0)
    //print('Num:'.$Phs_POST['numCards'].' Time:'.$Phs_POST['cardTime']);
    if (($servicePlanInfoArray = $dbc->getServicePlanInfo($selectedServicePlan)) == Null) {
     $Phs_ErrMsg = 'Invalid Service Plan assigned for this User';
   //print 'Invalid Service Plan assigned for this User';
    } 
    //print_r($servicePlanInfoArray);
    $radGroupName = strtolower($phs_client_info['client_address_country']) . '_' . strtolower($phs_client_info['client_address_code']) . '_' . $servicePlanInfoArray['package_type_radgroupext'] . ($_userMacGroup > 0 ? '_' . $_userMacGroup : '');
    $rowin = array(
        'uuname'                  => 'NewUser',
        'user_value'              => 'NewPw',
        'user_location'           => '',
        'user_client_package_id'  => $Phs_POST['ServicePlanSelect'],
        'user_firstname'          => '',
        'user_lastname'           => '',
        'user_email'              => '',
        'user_phone'              => '',
        'user_address'            => '',
        'user_payment'            => '',
        'user_status'             => PHS_ST_PREPAID,
        'user_notes'              => '',
        'user_nas_id'             => $phs_nas_id,
        'user_client_id'          => $phs_client_id,
        'user_mac_group'          => $_userMacGroup,
        'usttm'          	        => PHS_LDATE,
        'user_stoptime'           => 0,
        'ulsttm'                  => $phs_client_info['client_address_code'], // field 'abuse'
        'rad_usergroup_groupname' => $radGroupName,
        'client_address_location_str'       => $phs_client_info['client_address_location_str']);
    $_cardArray = $dbc->createAccountCards($rowin, $Phs_POST['numCards']);
    if ($_cardArray[0] <> 0) { // [0] contains 0 if success, else -1
          // OK, we got an error
      $process_error = True;
    } else {
      $Phs_InfoMsg = $Phs_POST['numCards'] . ' Card'. ($Phs_POST['numCards'] > 1 ? 's' : '') .' successfully created';
      //$a->setAuthData('Phs_InfoMsg', $Phs_InfoMsg);
       //header('Location: ' . PHS_FILE_PREPAID . );
      //exit;
      //print_r($_cardArray);
      //print_r($data);
      //$data = $_cardArray;
/***************************
* Print Cards in PDF format
****************************/

      require(FPDF_PATH .'fpdf.php');
      require_once('label/PDF_Label.php');
      //PDF_Label ($format, $unit='mm', $posX=1, $posY=1) 
      //$pdf = new PDF_Label('8600', 'mm', 1, 1);
      $pdf = new PDF_Label('5163b', 'mm', 1, 1);
      $pdf->Open();
      //$pdf->AddPage();
      // Print labels

      $data = array('<b>Username</b>', '<b>Password</b>');
      $pdf->SetFont('Arial');
      foreach ($_cardArray as $key => $value) {
        if ($key == 0) continue; // skip first element
        $_userName = normalizeUsername($value['uuname']);
        $_passWord = $value['user_value'];
        $data[] = $_userName;
        $data[] = $_passWord;
        //$pdf->Add_PDF_Label(sprintf("%s\n\n%s\n%s\n\n%s\n\n%s",
        //'pointHotspot.com Prepaid Internet Card', 'Username: '. $_userName, 'Password: ' . $_passWord, 'Access Plan: ' . $_planShort , 'Card by: ' . $phs_client_info['client_company']));

        // customised Add_PDF_Label - 20070703gr
        //$pdf->Add_PDF_Label('pointHotspot.com Prepaid Internet Card', 8, sprintf("%s\n%s", 'Username: '. $_userName, 'Password: ' . $_passWord), 12, sprintf("%s\n%s",
	if (PHS_CLIENT_ID == 122) {
		$pdf->Add_PDF_Label('Prepaid Internet Card', 8, sprintf("%s\n%s", 'Username: '. $_userName, 'Password: ' . $_passWord), 12, sprintf("%s\n%s",
        'Access Plan: ' . $_planShort . ($_userMacGroup > 0 ? ' (' . $_userMacGroup . ')' : ''), 'Card by: ' . $phs_client_info['client_company']), 8);
	} else {
		$pdf->Add_PDF_Label('pointHotspot.com Prepaid Internet Card', 8, sprintf("%s\n%s", 'Username: '. $_userName, 'Password: ' . $_passWord), 12, sprintf("%s\n%s",
        'Access Plan: ' . $_planShort . ($_userMacGroup > 0 ? ' (' . $_userMacGroup . ')' : ''), 'Card by: ' . $phs_client_info['client_company']), 8);
	}
      }
      $smarty->assign('cardTask', 11); // cards created
      $_tdWidth = '80|80';
      $_colSize = '2';
      //function Image($file,$x,$y,$w=0,$h=0,$type='',$link='')
      //$pdf->Image('images/box_mtl_ctr.jpg',30,30,40);

      //$pdf->Output('test.pdf',false);

      //$smarty->assign('phs_printLabel', '<a href="test.pdf" target="_blank">Print these Cards</a></td></tr>');

      $_fdate = date(PHS_4FDATE);
      $_fext = ''; // filename extension for multiple files e.g. -1, -2, -3 etc.

      $_printFilename = PHS_CLIENT_ACODE . $_fdate . $_fext;
      if (!file_exists(PHS_PREPAID_DIR . PHS_CLIENT_ID)) {
        //print('Directory does not exist');
        //print(PHS_PREPAID_DIR . PHS_CLIENT_ID);exit;
        @mkdir(PHS_PREPAID_DIR . PHS_CLIENT_ID, 0755);
        //exit;
      }

// now check if file already exists, add extension if exist
      $ix = 0;
      while (True) {
        if (file_exists(PHS_PREPAID_DIR . PHS_CLIENT_ID . '/' . $_printFilename)) {
          $_printFilename = PHS_CLIENT_ACODE . $_fdate . '-' . ++$ix;
        } else {
          break;
        }
      }
      $_printFilenamePath = PHS_PREPAID_DIR . PHS_CLIENT_ID . '/' . $_printFilename;

	// create unique card file outside of web directory tree
      $pdf->Output($_printFilenamePath, false);

      //$smarty->assign('phs_printLabel', '<a href="printcard.php?fn=' . $_printFilename . '" target="_blank">Print these Cards</a></td></tr>');
      $smarty->assign('phs_printLabel', '<a href="printcard.php?fn=' . $_printFilename . '">Print these Cards</a></td></tr>');
      
    }
  }
  // show cards in use or unused
} elseif (isset($Phs_GET['use']) || isset($Phs_GET['unused']) || isset($Phs_GET['expired']) || isset($Phs_GET['search'])) {
/******************************
* Display Section
*******************************/
  if (isset($Phs_GET['search']) && !empty($Phs_GET['search'])) {
    $searchstr = $Phs_GET['search'];// need to check this!
    $smarty->assign('Phs_search', $searchstr);
  }
  if (isset($Phs_GET['use'])) { // show cards in use
    $mainHeadline .= ' Cards in use';
    //$smarty->assign('cardTask', 2);
    $smarty->assign('cardTask', 3);
    $pageArg = 'use';
    $cardType = PPCARD_TYPE_INUSE; // prepaid in use
    $_tdWidth = '50|30|100|120|120|120';
    $_colSize = 7;
  } elseif (isset($Phs_GET['unused'])) { // show unused cards
    $mainHeadline .= ' unused Cards';
    $smarty->assign('cardTask', 3);
    $pageArg = 'unused';
    $cardType = PPCARD_TYPE_UNUSED; // prepaid unused
    $_tdWidth = '65|100|100|';
    $_colSize = 4;
  } elseif (isset($Phs_GET['expired'])) { // show unused cards
    $mainHeadline .= ' expired Cards';
    $smarty->assign('cardTask', 3);
    $pageArg = 'expired';
    $cardType = PPCARD_TYPE_EXPIRED; // prepaid expired
    $_tdWidth = '50|30|100|120|120|120|';
    $_colSize = 7;
    //$_tdWidth = '65|100|120|120|120|';
    //$_colSize = 6;
  } else {
    $mainHeadline .= ' Cards - Search for a card';
    $smarty->assign('cardTask', 3);
    $cardType = PPCARD_TYPE_ALL; // prepaid expired
    $pageArg = 'all';
    $_tdWidth = '50|30|100|120|120|120|';
    $_colSize = 7;
    //print('Prepaid Card Info');

  }
  //$smarty->assign('pageArg', $_SERVER['PHP_SELF'].'?'.$pageArg);
  if (!isset($Phs_GET['pageID']) ? $from=1 : '');

  if (isset($Phs_GET['sort']) && !empty($Phs_GET['sort'])) {
    $sortstr = $Phs_GET['sort'];// need to check this!
    switch(strtolower($sortstr)) {
    case 'login':
      $sortorder = 'u.uuname, u.user_lastname';
      break;
    case 'created':
      $sortorder = 'user_ndate_tz DESC, u.user_lastname, u.user_firstname';
      break;
    case 'atype':
      //$sortorder = 'pt.package_type_short, u.user_lastname, u.user_firstname';
      $sortorder = 'pt.package_type_interval, u.user_lastname, u.user_firstname';
      $typeOrderStr = 'dtype';
      break;
    case 'dtype':
      //$sortorder = 'pt.package_type_short DESC, u.user_lastname, u.user_firstname';
      $sortorder = 'pt.package_type_interval DESC, u.user_lastname, u.user_firstname';
      $typeOrderStr = 'atype';
      break;
    case 'inuse':
      $sortorder = 'u.ulsttm DESC, u.user_lastname, u.user_firstname';
      break;
    case 'astat':
      $sortorder = 'user_status, u.user_lastname, u.user_firstname';
      break;
    case 'dstat':
      $sortorder = 'user_status DESC, u.user_lastname, u.user_firstname';
      break;
    case 'atime':
      $sortorder = 'time_total, u.user_lastname, u.user_firstname';
      $timeOrderStr = 'dtime';
      break;
    case 'dtime':
      $sortorder = 'time_total DESC, u.user_lastname, u.user_firstname';
      $timeOrderStr = 'atime';
      break;
    case 'se':
      $sortorder = 'radacct_stoptime DESC, u.user_lastname, u.user_firstname';
      break;
    }
  }  

  $userarray = $dbc->getAllUsers($phs_nas_id, $cardType, $searchstr, $sortorder, ($from - 1) * $pageparams['perPage'], $pageparams['perPage'], $maxpages);

  //print_r($userarray);

  $pageparams['totalItems'] = $userarray[0]['numrows'];
  $mainHeadline .= ' (' . $userarray[0]['numrows'] . ')';

  $pager = & Pager::factory($pageparams);
  $links = $pager->getLinks();

  //$data = array('<a href="' . $Phs_Page . '?' . $pageArg . '&sort=status" title="Sort by Status" alt="Sort by Status"><b>Status</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=type" title="Sort by Type" alt="Sort by Type"><b>Type</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login" title="Sort by Login Id" alt="Sort by Login Id"><b>Login Id</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=created" title="Sort by Date" alt="Sort by Date created"><b>Created</b></a>');
  $data = array('<a href="' . $Phs_Page . '?' . $pageArg . '"><b>Status</b></a>');
  
  //$data[2] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=' . $typeOrderStr . '" title="Sort by Type" alt="Sort by Type"><b>Type</b></a>';
  //$data[3] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login" title="Sort by Login Id" alt="Sort by Login Id"><b>Login Id</b></a>';

  if ($cardType == PPCARD_TYPE_UNUSED) {
    $data[1] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=' . $typeOrderStr . '" title="Sort by Type" alt="Sort by Type"><b>Type</b></a>';
    $data[2] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login" title="Sort by Login Id" alt="Sort by Login Id"><b>Login Id</b></a>';
    $data[3] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=created" title="Sort by Date created" alt="Sort by Date created"><b>Created</b></a>';
  } elseif ($cardType == PPCARD_TYPE_INUSE OR $cardType == PPCARD_TYPE_EXPIRED OR $cardType == PPCARD_TYPE_ALL) {
    $data[1] = '<a href=""><b>Details</b></a>'; 
    $data[2] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=' . $typeOrderStr . '" title="Sort by Type" alt="Sort by Type"><b>Type</b></a>';
    $data[3] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login" title="Sort by Login Id" alt="Sort by Login Id"><b>Login Id</b></a>';
    $data[4] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=inuse" title="Sort by Time in use" alt="Sort by Time in use"><b>In use since</b></a>';
    $data[5] = '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=se" title="Sort by Session End" alt="Sort by Session End"><b>Session End</b></a>';
    //$data[5] =  '<a href="' . $Phs_Page . '?sort=timeused" title="Sort by Time used" alt="Sort by Time used"><b>Time used</b></a>';
    $data[6] =  '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=' . $timeOrderStr . '" title="Sort by Time used" alt="Sort by Time used"><b>Time used</b></a>';
  }
  for ($idx=1; $idx < sizeof($userarray); $idx++) {
    $_onlineIcon = '';
    $remainingOnlineTime = 0;
    if ($cardType == PPCARD_TYPE_INUSE OR $cardType == PPCARD_TYPE_EXPIRED OR $cardType == PPCARD_TYPE_ALL) {
      $data = array_merge2($data, array(
        (isset($userarray[$idx]['time_total']) && $userarray[$idx]['time_total'] > 0 ? 
        (is_null($dbc->getUserOnlineStatus($userarray[$idx]['user_id'])) ? 
        //($userarray[$idx]['package_type_interval'] > $userarray[$idx]['time_total'] ? 'In use' : 'Expired') : 'Online&nbsp;<img src="images/icon_online.gif" alt="User is online" title="User is online" align="center" class="icon" />') : 'Ready'),
        ($userarray[$idx]['user_stat'] == PHS_ST_EXPIRED ? 'Expired' : 'In use') : 'Online&nbsp;<img src="images/icon_online.gif" alt="User is online" title="User is online" align="center" class="icon" />') : 'Ready'),
        '<a href="' . PHS_FILE_USERREPORT . '?period=all&usid=' . $userarray[$idx]['user_id'] . '"><img src="images/folder.gif" alt="Show Session Details" title="Show Session Details" width="16" height="13" /></a>',
        $userarray[$idx]['package_type_short'], '<a href="' . PHS_FILE_USEREDIT . '?usid=' . $userarray[$idx]['user_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '">' . normalizeUsername($userarray[$idx]['uuname']) . '</a>',
        $userarray[$idx]['ulsttm'],
        $userarray[$idx]['radacct_stoptime'], 
        (isset($userarray[$idx]['time_total']) ? convertOnlineTime($userarray[$idx]['time_total'], True) : 'nottin')));
        //convertOnlineTime($userarray[$idx]['time_total'], True)));

        //$data[1] = '<a href="' . PHS_FILE_USERREPORT . '?period=all&usid=' . $userarray[$idx]['user_id'] . '"><img src="images/folder.gif" alt="Show Session Details" title="Show Session Details" width="16" height="13" /></a>';
    } else {

      $data = array_merge2($data, array('Ready', $userarray[$idx]['package_type_short'], '<a href="' . PHS_FILE_USEREDIT . '?usid=' . $userarray[$idx]['user_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '">' . normalizeUsername($userarray[$idx]['uuname']) . '</a>', $userarray[$idx]['user_ndate_tz']));
    }
  }
  $a->setAuthData('Phs_NextPage', PHS_FILE_PREPAID . (empty($pageArg) ? '' : '?' . $pageArg));
  $smarty->assign('pagenav', $links['all']);
  $smarty->assign('searchFieldHidden', (empty($pageArg) ? '' : $pageArg));
}
  //$smarty->assign('searchFieldEnabled', 1);
  $smarty->assign('searchFieldEnabled', 0);
//
  // MAC address restriction group
if (PHS_MACRESTRICT) {
  $smarty->assign('macRestrict_idx', array(0,1));
  $smarty->assign('macRestrict_names', array('none','1'));
  $smarty->assign('macRestrict_id', 'none');
  $smarty->assign('macRestrictOn', True);
}

$smarty->assign('tdwidth', $_tdWidth);
$smarty->assign('colsize', $_colSize);
require_once('includes/trailer-inc.php');
$smarty->assign('mainHeadline', $mainHeadline);
$smarty->display('prepaid.tpl');
?>
