<?php
/***************************************************************
*
*	User Report
*	
*	2006-03-26 Gunther Richter - Ultra Consulting Network Limited
*
****************************************************************/

/*
  - Searcheable by username
  - Time period selection or current account (use StartTime)
  - Display page with multiple users and click to expand a single user
    Expanded data shows every session during the period
    E.g. Start, Stop, Duration, download, upload, session termination cause 

*/
require('includes/init-inc.php');	// initialize 
require('includes/reports-inc.php');	// initialize 

	// check if user is logged in and has permissions to access this page
$perm = accessControl(PHS_PERM_SUPADMIN+PHS_PERM_ADMIN+PHS_PERM_PUSER+PHS_PERM_USER);

$a->setAuthData('Phs_NextPage', PHS_FILE_USERREPORT);
$rcl = new reports($params);

$_periodSelector = '';
$mainHeadline = 'User Report';
$_colSize = 6;
$_tdWidth = '35|70|100|60|90|';
$searchstr = '';
$sortorder = '';
$_startDate = 0;
$_startTime = '00:00:00';
$_stopDate = 0;
$_stopTime = '23:59:59';
$_startDateTimeStr = '';
$_stopDateTimeStr = '';
$typeOrderStr = 'login';
$pageArg = '';
$_userId = 0;

//print_r($Phs_POST);

if (isset($Phs_GET['period']) || isset($Phs_GET['search'])) {
  if (isset($Phs_GET['search']) && !empty($Phs_GET['search'])) {
    $searchstr = $Phs_GET['search'];// need to check this!
    $smarty->assign('Phs_search', $searchstr);
  } elseif (isset($Phs_GET['filter']) && !empty($Phs_GET['filter'])) {
    $searchstr = $Phs_GET['filter'];
    $smarty->assign('searchFilter', $searchstr);
  }
  if (isset($Phs_GET['usid']) && $Phs_GET['usid'] > 0) {
    $_userId = $Phs_GET['usid'];
    $sortorder = 'r.radacct_mdate DESC, u.uuname, u.user_lastname';
    $pageArg .= 'usid=' . $_userId . '&';
  }
  
  if (isset($Phs_GET['period'])) {
    //print(' SUBMIT2 ');
    $_periodSelector = $Phs_GET['period'];
    if ($_periodSelector == 'period') {

      if (isset($Phs_GET['submit2'])) {
        //print('Submitted');
        if (isset($Phs_GET['StartDate']) && isset($Phs_GET['StartTime'])) {
          $_startDate = $Phs_GET['StartDate']['Date_Year'] . '-' . 
                          $Phs_GET['StartDate']['Date_Month'] . '-' . 
                          $Phs_GET['StartDate']['Date_Day'];
          $_startTime = $Phs_GET['StartTime']['Time_Hour'] . ':' . 
                          $Phs_GET['StartTime']['Time_Minute'] . ':00';

            // 12/24 h conversion
          if (isset($Phs_GET['StartTime']['Time_Meridian']) && !empty($Phs_GET['StartTime']['Time_Meridian'])) {
            $_startTime = date('H:i:s', strtotime($_startTime . " " . $Phs_GET['StartTime']['Time_Meridian'] ));
          }

          //print( date("H:i:s", strtotime("1:30 pm")) );
          //print('Start:'.$_startTime);

          $_startDateTimeStr = $_startDate . ' ' . $_startTime;
          if (!checkdate($Phs_GET['StartDate']['Date_Month'], $Phs_GET['StartDate']['Date_Day'], $Phs_GET['StartDate']['Date_Year'])) {
            $Phs_ErrMsg = 'Invalid Start Date';
            $process_error = True;
          }
          //print($_startDateTimeStr);
        }
        if (isset($Phs_GET['StopDate']) && isset($Phs_GET['StopTime'])) {
          $_stopDateTimeStr = $Phs_GET['StopDate']['Date_Year'] . '-' . 
          $_stopDate = $Phs_GET['StopDate']['Date_Year'] . '-' . 
                       $Phs_GET['StopDate']['Date_Month'] . '-' . 
                       $Phs_GET['StopDate']['Date_Day'];
          $_stopTime = $Phs_GET['StopTime']['Time_Hour'] . ':' . 
                       $Phs_GET['StopTime']['Time_Minute'] . ':00';

            // 12/24 h conversion
          if (isset($Phs_GET['StopTime']['Time_Meridian']) && !empty($Phs_GET['StopTime']['Time_Meridian'])) {
            $_stopTime = date('H:i:s', strtotime($_stopTime . " " . $Phs_GET['StopTime']['Time_Meridian'] ));
          }
          //print('Stop:'.$_stopTime);

          $_stopDateTimeStr = $_stopDate . ' ' . $_stopTime;
          if (!checkdate($Phs_GET['StopDate']['Date_Month'], $Phs_GET['StopDate']['Date_Day'], $Phs_GET['StopDate']['Date_Year'])) {
            $Phs_ErrMsg = 'Invalid Stop Date';
            $process_error = True;
          }
        }
        //print($_startDateTimeStr.' -- '.$_stopDateTimeStr);
      }
      $smarty->assign('showStartTime', True);
      $smarty->assign('showStopTime', True);
      $smarty->assign('StartDate', $_startDate); // set time display format
      $smarty->assign('StartTime', $_startTime); // set time display format
      $smarty->assign('StopDate', $_stopDate); // set time display format
      $smarty->assign('StopTime', $_stopTime); // set time display format
    }
  }

  //print('pSel:'.$_periodSelector);
  if ($_periodSelector != 'period' || ($_periodSelector == 'period' && isset($Phs_GET['submit2']))) {

  //print('pSel:'.$_periodSelector);
  if (isset($Phs_GET['sort']) && !empty($Phs_GET['sort'])) {
    $sortstr = $Phs_GET['sort'];// need to check this!
    switch(strtolower($sortstr)) {
    case 'login':
      //$sortorder = ($_userId > 0 ? 'r.radacct_mdate DESC,' : '') . 'u.uuname, u.user_lastname';
      $sortorder = 'u.uuname, u.user_lastname';
      //$typeOrderStr = 'login';
      break;
    case 'total':
      $sortorder = 'time_total DESC, u.user_lastname, u.user_firstname';
      break;
    case 'up':
      $sortorder = 'input_total DESC, u.user_lastname, u.user_firstname';
      //$typeOrderStr = 'up';
      break;
    case 'down':
      $sortorder = 'output_total DESC, u.user_lastname, u.user_firstname';
      //$typeOrderStr = 'down';
      break;
    case 'se':
      $sortorder = 'radacct_stoptime DESC, u.user_lastname, u.user_firstname';
      break;
    case 'ss':
      $sortorder = 'radacct_starttime DESC, u.user_lastname, u.user_firstname';
      break;
    case 'tc':
      $sortorder = 'radacct_terminatecause, u.user_lastname, u.user_firstname';
      break;
    }
  }  
  $pageArg .= 'period=' . $_periodSelector;

  if (!$process_error) {
    if (!isset($Phs_GET['pageID']) ? $from=1 : '');

    $_ureportArray = $rcl->usageReport(PHS_CLIENT_ID, $_userId, $_periodSelector, $_startDateTimeStr, $_stopDateTimeStr, $searchstr, $sortorder, ($from - 1) * $pageparams['perPage'], $pageparams['perPage'], $maxpages);
    //print_r($_ureportArray);

    $pageparams['totalItems'] = $_ureportArray[0]['numrows'];
    $mainHeadline .= ' (' . $_ureportArray[0]['numrows'] . ')';

    $pager = & Pager::factory($pageparams);
    $links = $pager->getLinks();

    
    
    if ($_userId > 0) {
      $data = array('<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login"><b>Login Id</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=total"><b>Total</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=up"><b>Upload</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=down"><b>Download</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=ss"><b>Session Start</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=se"><b>Session End</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=tc"><b>Termination</b></a>', '<a href="' . $Phs_Page . '?' . $pageArg . '&sort=mac"><b>MAC</b></a>');
    } else {
      $data = array('<a href=""><b>Details</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=login"><b>Login Id</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=total"><b>Total</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=up"><b>Upload</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=down"><b>Download</b></a>','<a href="' . $Phs_Page . '?' . $pageArg . '&sort=se"><b>Session End</b></a>');
    }
    for ($idx=1; $idx < sizeof($_ureportArray); $idx++) {
      if ($_userId > 0) {
        $_colSize = 8;
        $_tdWidth = '100|100|60|60|110|110|110|110';
        $data = array_merge2($data, array(
        '<a href="' . PHS_FILE_USEREDIT . '?usid=' . $_ureportArray[$idx]['user_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '">' . normalizeUsername($_ureportArray[$idx]['uuname']) . '</a>',
        convertOnlineTime($_ureportArray[$idx]['time_total'], True), 
        octets2String($_ureportArray[$idx]['input_total']),
        octets2String($_ureportArray[$idx]['output_total']), 
        $_ureportArray[$idx]['radacct_starttime'],
        $_ureportArray[$idx]['radacct_stoptime'],
        $_ureportArray[$idx]['radacct_terminatecause'],
        $_ureportArray[$idx]['radacct_calling_stationid']));
      } else {
        $_colSize = 6;
        $_tdWidth = '35|100|100|60|60|110';
      '<img src="images/' .
      $data = array_merge2($data, array('<a href="' . PHS_FILE_USERREPORT . '?' . $pageArg . '&usid=' . $_ureportArray[$idx]['user_id'] . '"><img src="images/folder.gif" alt="Show Session Details" title="Show Session Details" width="16" height="13" /></a>',
        '<a href="' . PHS_FILE_USEREDIT . '?usid=' . $_ureportArray[$idx]['user_id'] . (isset($Phs_GET[$phs_PageStr]) ? '&' . $phs_PageStr . '=' . $Phs_GET[$phs_PageStr] : '') . '">' . normalizeUsername($_ureportArray[$idx]['uuname']) . '</a>',
        convertOnlineTime($_ureportArray[$idx]['time_total'], True), 
        octets2String($_ureportArray[$idx]['input_total']),
        octets2String($_ureportArray[$idx]['output_total']), 
        $_ureportArray[$idx]['radacct_stoptime']));
      }
    }
    $smarty->assign('pagenav', $links['all']);
  }
  }
}

  // assign radio buttons
$smarty->assign('periods_ids', array('today','week','month','lmonth','period','all'));
$smarty->assign('periods', array('Today','This week','This month','Last month','Specify time period','All'));
$smarty->assign('period_id', $_periodSelector);

$smarty->assign('tdwidth', $_tdWidth);
$smarty->assign('colsize', $_colSize);
$smarty->assign('searchFieldEnabled', 1);
$smarty->assign('time24', PHS_TIME24); // set time display format
require_once('includes/trailer-inc.php');
$smarty->assign('mainHeadline', $mainHeadline);
$smarty->display('userreport.tpl');
?>
